/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;

public abstract class ModStructureUtils {
    public static boolean isRelativelyFlat(Structure.GenerationContext context, int chunkSearchRadius, int maxTerrainHeightVariation) {
        ChunkPos chunkpos = context.f_226628_();
        int maxTerrainHeight = Integer.MIN_VALUE;
        int minTerrainHeight = Integer.MAX_VALUE;
        for (int chunkX = chunkpos.f_45578_ - chunkSearchRadius; chunkX <= chunkpos.f_45578_ + chunkSearchRadius; chunkX += chunkSearchRadius) {
            for (int chunkZ = chunkpos.f_45579_ - chunkSearchRadius; chunkZ <= chunkpos.f_45579_ + chunkSearchRadius; chunkZ += chunkSearchRadius) {
                BlockPos blockpos = new BlockPos((chunkX << 4) + 7, 0, (chunkZ << 4) + 7);
                int height = context.f_226622_().m_214096_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
                maxTerrainHeight = Math.max(maxTerrainHeight, height);
                minTerrainHeight = Math.min(minTerrainHeight, height);
                if (!context.f_226622_().m_214184_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_226629_(), context.f_226624_()).m_183556_(height).m_60819_().m_76178_()) {
                    return false;
                }
                if (maxTerrainHeight - minTerrainHeight < maxTerrainHeightVariation) continue;
                return false;
            }
        }
        return maxTerrainHeight - minTerrainHeight <= maxTerrainHeightVariation;
    }

    public static boolean isOnLand(Structure.GenerationContext context, int chunkSearchRadius) {
        ChunkPos chunkpos = context.f_226628_();
        return ModStructureUtils.isDryChunkCenter(context, new ChunkPos(chunkpos.f_45578_ - chunkSearchRadius, chunkpos.f_45579_ - chunkSearchRadius)) && ModStructureUtils.isDryChunkCenter(context, new ChunkPos(chunkpos.f_45578_ - chunkSearchRadius, chunkpos.f_45579_ + chunkSearchRadius)) && ModStructureUtils.isDryChunkCenter(context, new ChunkPos(chunkpos.f_45578_ + chunkSearchRadius, chunkpos.f_45579_ - chunkSearchRadius)) && ModStructureUtils.isDryChunkCenter(context, new ChunkPos(chunkpos.f_45578_ + chunkSearchRadius, chunkpos.f_45579_ + chunkSearchRadius));
    }

    private static boolean isDryChunkCenter(Structure.GenerationContext context, ChunkPos chunkPos) {
        BlockPos centerOfChunk = chunkPos.m_151394_(0);
        int landHeight = context.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_226629_(), context.f_226624_());
        BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
        return topBlock.m_60819_().m_76178_();
    }
}

