/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.loot;

import dev.architectury.event.events.common.LootEvent;
import java.util.Set;
import net.bandit.many_bows.config.BowLootConfig;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModLootModifiers {
    private static final BowLootConfig CONFIG = BowLootConfig.loadConfig();
    private static final Set<ResourceLocation> EASY_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/simple_dungeon"), ModLootModifiers.createKey("minecraft", "chests/abandoned_mineshaft"));
    private static final Set<ResourceLocation> MEDIUM_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/jungle_temple"), ModLootModifiers.createKey("minecraft", "chests/pillager_outpost"), ModLootModifiers.createKey("minecraft", "chests/abandoned_mineshaft"), ModLootModifiers.createKey("minecraft", "chests/simple_dungeon"));
    private static final Set<ResourceLocation> HARD_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/stronghold_corridor"), ModLootModifiers.createKey("minecraft", "chests/nether_bridge"), ModLootModifiers.createKey("minecraft", "chests/bastion_treasure"));
    private static final Set<ResourceLocation> ENDGAME_LOOT_TABLES = Set.of(ModLootModifiers.createKey("minecraft", "chests/end_city_treasure"), ModLootModifiers.createKey("minecraft", "chests/nether_bridge"), ModLootModifiers.createKey("minecraft", "chests/bastion_treasure"));

    private static ResourceLocation createKey(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static void registerLootModifiers() {
        LootEvent.MODIFY_LOOT_TABLE.register((lootDataManager, id, context, builtin) -> {
            if (!builtin) {
                return;
            }
            if (ModLootModifiers.CONFIG.easyLootEnabled && EASY_LOOT_TABLES.contains(id)) {
                context.addPool(ModLootModifiers.createCommonBowPool(ModLootModifiers.CONFIG.easyLootDropChance));
            }
            if (ModLootModifiers.CONFIG.mediumLootEnabled && MEDIUM_LOOT_TABLES.contains(id)) {
                context.addPool(ModLootModifiers.createUncommonBowPool(ModLootModifiers.CONFIG.mediumLootDropChance));
            }
            if (ModLootModifiers.CONFIG.hardLootEnabled && HARD_LOOT_TABLES.contains(id)) {
                context.addPool(ModLootModifiers.createRareBowPool(ModLootModifiers.CONFIG.hardLootDropChance));
            }
            if (ModLootModifiers.CONFIG.endgameLootEnabled && ENDGAME_LOOT_TABLES.contains(id)) {
                context.addPool(ModLootModifiers.createEpicBowPool(ModLootModifiers.CONFIG.endgameLootDropChance));
            }
        });
    }

    private static LootPool.Builder createCommonBowPool(float chance) {
        return LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.ANCIENT_SAGE_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.AETHERS_CALL.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.BURNT_RELIC.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.POWER_CRYSTAL.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.EMERALD_SAGE_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.TORCHBEARER.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.DEMONS_GRASP.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance));
    }

    private static LootPool.Builder createUncommonBowPool(float chance) {
        return LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.CYROHEART_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.POWER_CRYSTAL.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.TORCHBEARER.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.EMERALD_SAGE_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.DEMONS_GRASP.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance));
    }

    private static LootPool.Builder createRareBowPool(float chance) {
        return LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.SENTINELS_WRAITH.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.CURSED_STONE.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.SOLAR_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.ARC_HEAVENS.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.SCATTER_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.VITALITY_WEAVER.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.SPECTRAL_WHISPER.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.WEBSTRING.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance));
    }

    private static LootPool.Builder createEpicBowPool(float chance) {
        return LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.FLAME_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.DARK_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.ARCANE_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.DRAGONS_BREATH.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.WIND_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.CYROHEART_BOW.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.SHULKER_BLAST.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.ASTRAL_BOUND.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.AURORAS_GRACE.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance));
    }
}

