/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TidalArrow
extends AbstractArrow {
    public TidalArrow(EntityType<? extends TidalArrow> entityType, Level level) {
        super(entityType, level);
    }

    public TidalArrow(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.TIDAL_ARROW.get(), shooter, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            for (int i = 0; i < 5; ++i) {
                double xOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double yOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double zOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + motion.f_82479_ * (double)i * 0.1, this.m_20186_() + motion.f_82480_ * (double)i * 0.1, this.m_20189_() + motion.f_82481_ * (double)i * 0.1, xOffset, yOffset, zOffset);
            }
        }
    }

    protected float m_6882_() {
        return 1.0f;
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            hitEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2));
            this.createWaterBindingEffect(hitEntity);
        }
    }

    public double m_36789_() {
        double base = super.m_36789_();
        return this.m_20069_() ? base * 2.5 : base;
    }

    private void createWaterBindingEffect(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos entityPos = entity.m_20183_();
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 4, false, false));
            for (int i = 0; i < 30; ++i) {
                double angle = (double)i * Math.PI / 15.0;
                double xOffset = Math.cos(angle) * 0.5;
                double zOffset = Math.sin(angle) * 0.5;
                double yOffset = 0.3 * (double)i;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)entityPos.m_123341_() + xOffset, (double)entityPos.m_123342_() + yOffset, (double)entityPos.m_123343_() + zOffset, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_9236_().m_5594_(null, entityPos, SoundEvents.f_11917_, this.m_5720_(), 0.5f, 0.8f);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.createWaterSplash(result.m_82450_());
    }

    private void createWaterSplash(Vec3 position) {
        if (!this.m_9236_().m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                double xOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double yOffset = this.f_19796_.m_188500_();
                double zOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, position.f_82479_ + xOffset, position.f_82480_ + yOffset, position.f_82481_ + zOffset, 0.0, 0.1, 0.0);
            }
            this.m_9236_().m_6263_(null, position.f_82479_, position.f_82480_, position.f_82481_, SoundEvents.f_12436_, this.m_5720_(), 1.0f, 1.0f);
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

