/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EnchantmentRegistry;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpectralArrow
extends AbstractArrow {
    private int remainingObstacles;
    private int lifespan = 140;

    public SpectralArrow(EntityType<? extends SpectralArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SpectralArrow(Level level, LivingEntity shooter, ItemStack bow) {
        super((EntityType)EntityRegistry.SPECTRAL_ARROW.get(), shooter, level);
        this.m_36781_(7.0);
        int spectralLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentRegistry.SPECTRAL.get()), (ItemStack)bow);
        this.remainingObstacles = 1 + spectralLevel;
    }

    public void m_8119_() {
        Vec3 nextPosition;
        super.m_8119_();
        if (--this.lifespan <= 0) {
            this.m_146870_();
            return;
        }
        Vec3 currentPosition = this.m_20182_();
        EntityHitResult entityHitResult = this.m_6351_(currentPosition, nextPosition = currentPosition.m_82549_(this.m_20184_()));
        if (entityHitResult != null) {
            this.m_5790_(entityHitResult);
            return;
        }
        BlockHitResult blockHitResult = this.m_9236_().m_45547_(new ClipContext(currentPosition, nextPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.m_8060_(blockHitResult);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.m_9236_().m_5776_()) {
            if (this.remainingObstacles > 0) {
                --this.remainingObstacles;
                Vec3 movement = this.m_20184_();
                Vec3 hitPos = result.m_82450_();
                this.m_6034_(hitPos.f_82479_ + movement.f_82479_ * 0.5, hitPos.f_82480_ + movement.f_82480_ * 0.5, hitPos.f_82481_ + movement.f_82481_ * 0.5);
                this.m_20256_(movement);
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        if (!this.m_9236_().m_5776_() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (super.m_5603_(result.m_82443_())) {
                target.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_()), (float)this.m_36789_());
                this.m_146870_();
            }
        }
    }

    public EntityHitResult m_6351_(Vec3 start, Vec3 end) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> super.m_5603_(entity));
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

