/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.providers;

import com.google.common.collect.ImmutableList;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.registry.DPBlocks;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SlabBlock;

public class DPRecipeProvider
extends VanillaRecipeProvider {
    public static final ImmutableList<ItemLike> IRON_SMELTABLES = ImmutableList.of((Object)((ItemLike)DPBlocks.GRANITE_IRON_ORE.get()));
    public static final ImmutableList<ItemLike> GOLD_SMELTABLES = ImmutableList.of((Object)((ItemLike)DPBlocks.GRANITE_GOLD_ORE.get()));
    private static final String HAS_ITEM = "has_item";

    public DPRecipeProvider(PackOutput output) {
        super(output);
    }

    protected CompletableFuture<?> m_253240_(CachedOutput output, ResourceLocation name, Advancement.Builder advancementBuilder) {
        if (RecipeBuilder.f_236353_.equals((Object)name)) {
            return CompletableFuture.completedFuture(null);
        }
        return super.m_253240_(output, name, advancementBuilder);
    }

    protected void m_245200_(Consumer<FinishedRecipe> cons) {
        DPRecipeProvider.oreSmelting(cons, IRON_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.f_42416_, 0.7f, 200, "iron_ingot");
        DPRecipeProvider.oreSmelting(cons, GOLD_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.f_42417_, 1.0f, 200, "gold_ingot");
        DPRecipeProvider.oreBlasting(cons, IRON_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.f_42416_, 0.7f, 100, "iron_ingot");
        DPRecipeProvider.oreBlasting(cons, GOLD_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.f_42417_, 1.0f, 100, "gold_ingot");
    }

    protected static void stoneCutting(Consumer<FinishedRecipe> cons, RecipeCategory category, ItemLike ingredient, List<ItemLike> results) {
        results.forEach(result -> SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)category, (ItemLike)result, (int)(result instanceof SlabBlock ? 2 : 1)).m_126132_(HAS_ITEM, (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)ingredient)).m_176500_(cons, DPRecipeProvider.find(BuiltInRegistries.f_257033_.m_7981_((Object)result.m_5456_()).m_135815_() + "_stonecutting_" + BuiltInRegistries.f_257033_.m_7981_((Object)ingredient.m_5456_()).m_135815_())));
    }

    protected static void variants(Consumer<FinishedRecipe> cons, ItemLike ingredient, @Nullable ItemLike slab, @Nullable ItemLike stairs, @Nullable ItemLike wall) {
        if (stairs != null) {
            DPRecipeProvider.m_176710_((ItemLike)stairs, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_126132_(HAS_ITEM, (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)ingredient)).m_176498_(cons);
        }
        if (slab != null) {
            DPRecipeProvider.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_126132_(HAS_ITEM, (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)ingredient)).m_176498_(cons);
        }
        if (wall != null) {
            DPRecipeProvider.m_245864_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_126132_(HAS_ITEM, (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)ingredient)).m_176498_(cons);
        }
    }

    protected static void oneToOneConversionRecipe(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ItemLike pResult, ItemLike pIngredient, @Nullable String pGroup, int pResultCount) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)pResult, (int)pResultCount).m_126209_(pIngredient).m_126145_(pGroup).m_126132_(DPRecipeProvider.m_176602_((ItemLike)pIngredient), (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)pIngredient)).m_176500_(pFinishedRecipeConsumer, DPRecipeProvider.find(DPRecipeProvider.m_176517_((ItemLike)pResult, (ItemLike)pIngredient)));
    }

    protected static void simpleCookingRecipe(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String pCookingMethod, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, int pCookingTime, ItemLike pIngredient, ItemLike pResult, float pExperience) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{pIngredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer).m_126132_(DPRecipeProvider.m_176602_((ItemLike)pIngredient), (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)pIngredient)).m_176500_(pFinishedRecipeConsumer, DPRecipeProvider.find(DPRecipeProvider.m_176632_((ItemLike)pResult) + "_from_" + pCookingMethod));
    }

    protected static void oreSmelting(Consumer<FinishedRecipe> pFinishedRecipeConsumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        DPRecipeProvider.oreCooking(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(Consumer<FinishedRecipe> pFinishedRecipeConsumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        DPRecipeProvider.oreCooking(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static void oreCooking(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer).m_126145_(pGroup).m_126132_(DPRecipeProvider.m_176602_((ItemLike)itemlike), (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)itemlike)).m_176500_(pFinishedRecipeConsumer, DPRecipeProvider.find(DPRecipeProvider.m_176632_((ItemLike)pResult) + pRecipeName + "_" + DPRecipeProvider.m_176632_((ItemLike)itemlike)));
        }
    }

    protected static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeCategory pUnpackedCategory, ItemLike pUnpacked, RecipeCategory pPackedCategory, ItemLike pPacked, String pUnpackedName, String pUnpackedGroup) {
        DPRecipeProvider.nineBlockStorageRecipes(pFinishedRecipeConsumer, pUnpackedCategory, pUnpacked, pPackedCategory, pPacked, DPRecipeProvider.m_176644_((ItemLike)pPacked), null, pUnpackedName, pUnpackedGroup);
    }

    protected static void nineBlockStorageRecipes(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeCategory pUnpackedCategory, ItemLike pUnpacked, RecipeCategory pPackedCategory, ItemLike pPacked, String pPackedName, @Nullable String pPackedGroup, String pUnpackedName, @Nullable String pUnpackedGroup) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)pUnpackedCategory, (ItemLike)pUnpacked, (int)9).m_126209_(pPacked).m_126145_(pUnpackedGroup).m_126132_(DPRecipeProvider.m_176602_((ItemLike)pPacked), (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)pPacked)).m_176500_(pFinishedRecipeConsumer, pUnpackedName);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)pPackedCategory, (ItemLike)pPacked).m_126127_(Character.valueOf('#'), pUnpacked).m_126130_("###").m_126130_("###").m_126130_("###").m_126145_(pPackedGroup).m_126132_(DPRecipeProvider.m_176602_((ItemLike)pUnpacked), (CriterionTriggerInstance)DPRecipeProvider.m_125977_((ItemLike)pUnpacked)).m_126140_(pFinishedRecipeConsumer, DungeonsPlus.locate(pPackedName));
    }

    private static String find(String key) {
        return DungeonsPlus.locate(key).toString();
    }
}

