/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.SpectatorTickHandler;
import net.orcinus.galosphere.client.gui.CombustionTableScreen;
import net.orcinus.galosphere.client.gui.GoldenBreathOverlay;
import net.orcinus.galosphere.client.gui.SpectatorVisionOverlay;
import net.orcinus.galosphere.client.gui.SpectreOverlay;
import net.orcinus.galosphere.client.model.BerserkerModel;
import net.orcinus.galosphere.client.model.PinkSaltPillarModel;
import net.orcinus.galosphere.client.model.PreservedModel;
import net.orcinus.galosphere.client.model.SparkleModel;
import net.orcinus.galosphere.client.model.SpecterpillarModel;
import net.orcinus.galosphere.client.model.SpectreModel;
import net.orcinus.galosphere.client.model.SterlingArmorModel;
import net.orcinus.galosphere.client.particles.CrystalRainParticle;
import net.orcinus.galosphere.client.particles.ImpactParticle;
import net.orcinus.galosphere.client.particles.IndicatorParticle;
import net.orcinus.galosphere.client.particles.SpectateOrbParticle;
import net.orcinus.galosphere.client.particles.providers.PinkSaltFallingDustProvider;
import net.orcinus.galosphere.client.particles.providers.SilverBombProvider;
import net.orcinus.galosphere.client.particles.providers.WarpedProvider;
import net.orcinus.galosphere.client.renderer.BerserkerRenderer;
import net.orcinus.galosphere.client.renderer.PinkSaltPillarRenderer;
import net.orcinus.galosphere.client.renderer.PinkSaltShardRenderer;
import net.orcinus.galosphere.client.renderer.PreservedRenderer;
import net.orcinus.galosphere.client.renderer.SparkleRenderer;
import net.orcinus.galosphere.client.renderer.SpectatorVisionRenderer;
import net.orcinus.galosphere.client.renderer.SpecterpillarRenderer;
import net.orcinus.galosphere.client.renderer.SpectreRenderer;
import net.orcinus.galosphere.client.renderer.ThrowableLaunchedProjectileRenderer;
import net.orcinus.galosphere.client.renderer.block.GildedBeadsRenderer;
import net.orcinus.galosphere.client.renderer.block.ShadowFrameBlockRenderer;
import net.orcinus.galosphere.client.renderer.layer.BannerLayer;
import net.orcinus.galosphere.client.renderer.layer.HorseBannerLayer;
import net.orcinus.galosphere.events.CameraEvents;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMenuTypes;
import net.orcinus.galosphere.init.GModelLayers;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.items.SaltboundTabletItem;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="galosphere", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;
    public static int clearWeatherTime;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)GMenuTypes.COMBUSTION_TABLE.get()), CombustionTableScreen::new);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register((Object)new GoldenBreathOverlay());
        eventBus.register((Object)new SpectreOverlay());
        eventBus.register((Object)new SpectatorVisionOverlay());
        eventBus.register((Object)new CameraEvents());
        eventBus.addListener(clientTickEvent -> SpectatorTickHandler.tick());
        event.enqueueWork(() -> {
            ItemProperties.register((Item)Items.f_42717_, (ResourceLocation)Galosphere.id("glow_flare"), (stack, world, entity, p_174608_) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.GLOW_FLARE.get())) ? 1.0f : 0.0f);
            ItemProperties.register((Item)Items.f_42717_, (ResourceLocation)Galosphere.id("spectre_flare"), (stack, world, entity, p_174608_) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.SPECTRE_FLARE.get())) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)GItems.BAROMETER.get()), (ResourceLocation)Galosphere.id("weather_level"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
                private double rotation;
                private int ticksBeforeChange;

                public float m_142187_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
                    int index;
                    Level level;
                    LivingEntity entity = livingEntity != null ? livingEntity : itemStack.m_41609_();
                    float[][] predicates = new float[][]{{0.15f, 0.13f, 0.21f, 0.28f, 0.36f, 0.44f, 0.52f, 0.59f, 0.7f, 0.75f, 0.82f, 0.9f}, {0.9f, 0.82f, 0.75f, 0.7f, 0.59f, 0.52f, 0.44f, 0.36f, 0.28f, 0.21f, 0.13f, 0.15f}};
                    if (entity == null) {
                        return 0.0f;
                    }
                    if (clientLevel == null && (level = entity.m_9236_()) instanceof ClientLevel) {
                        ClientLevel clientWorld;
                        clientLevel = clientWorld = (ClientLevel)level;
                    }
                    if (clientLevel == null) {
                        return 0.0f;
                    }
                    float speed = 0.00525f;
                    int clearWeatherTime = ClientEvents.clearWeatherTime;
                    int n = index = clearWeatherTime < 5 ? 0 : Math.max(0, clearWeatherTime / 1000);
                    float max = clearWeatherTime < 12000 ? predicates[clientLevel.m_46471_() ? 1 : 0][index] : (clientLevel.m_6106_().m_6533_() ? 0.0f : 1.0f);
                    float rainLevel = clientLevel.m_46722_(1.0f);
                    if ((rainLevel > 0.9f || rainLevel < 0.1f) && clearWeatherTime == 0 && this.ticksBeforeChange == 0) {
                        this.ticksBeforeChange = 800;
                    }
                    if (this.ticksBeforeChange > 0) {
                        --this.ticksBeforeChange;
                    }
                    if (!clientLevel.m_6042_().f_63858_() && clientLevel.m_213780_().m_188501_() < 0.1f) {
                        this.rotation = Mth.m_14109_((double)(Math.random() - this.rotation), (double)1.0);
                    }
                    if (this.rotation < (double)max && this.ticksBeforeChange == 0) {
                        this.rotation += (double)speed;
                    }
                    if (this.rotation > (double)max && this.ticksBeforeChange == 0) {
                        this.rotation -= (double)speed;
                    }
                    return this.rotation >= 0.99 ? 1.0f : (float)this.rotation;
                }
            });
            ItemProperties.register((Item)((Item)GItems.SALTBOUND_TABLET.get()), (ResourceLocation)Galosphere.id("using"), (stack, world, entity, i) -> entity != null && entity.m_21211_().m_41720_() instanceof SaltboundTabletItem ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)GItems.SALTBOUND_TABLET.get()), (ResourceLocation)Galosphere.id("cooldown"), (stack, world, entity, i) -> {
                Player player;
                return entity instanceof Player && (player = (Player)entity).m_36335_().m_41519_((Item)GItems.SALTBOUND_TABLET.get()) ? 1 : 0;
            });
        });
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addAfter(map, after, blk));
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addBefore(map, before, blk));
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike block) {
        map.putAfter((Object)FUNCTION.apply(after), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike block) {
        map.putBefore((Object)FUNCTION.apply(before), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void accept(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike block) {
        map.put((Object)new ItemStack(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    @SubscribeEvent
    public static void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        ResourceKey tabKey = event.getTabKey();
        if (tabKey.equals((Object)CreativeModeTabs.f_256788_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_152490_, (ItemLike)GBlocks.AMETHYST_STAIRS.get(), (ItemLike)GBlocks.AMETHYST_SLAB.get(), (ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)GBlocks.AMETHYST_LAMP.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST_SLAB.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get(), (ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), (ItemLike)GBlocks.ALLURITE_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_SLAB.get(), (ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_LAMP.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get(), (ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), (ItemLike)GBlocks.LUMIERE_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_SLAB.get(), (ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_LAMP.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get(), (ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_BLOCK.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_PANEL.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_PANEL_STAIRS.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_PANEL_SLAB.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_TILES.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_TILES_STAIRS.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_TILES_SLAB.get());
            ClientEvents.accept((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)GBlocks.SILVER_LATTICE.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256776_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_152468_, (ItemLike)GBlocks.SILVER_ORE.get(), (ItemLike)GBlocks.DEEPSLATE_SILVER_ORE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_152600_, (ItemLike)GBlocks.RAW_SILVER_BLOCK.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_152492_, (ItemLike)GBlocks.GLINTED_AMETHYST_CLUSTER.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), (ItemLike)GBlocks.ALLURITE_CLUSTER.get(), (ItemLike)GBlocks.GLINTED_ALLURITE_CLUSTER.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), (ItemLike)GBlocks.LUMIERE_CLUSTER.get(), (ItemLike)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_152475_, (ItemLike)GBlocks.GLOW_INK_CLUMPS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_220861_, (ItemLike)GBlocks.AMETHYST_LAMP.get(), (ItemLike)GBlocks.ALLURITE_LAMP.get(), (ItemLike)GBlocks.LUMIERE_LAMP.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256968_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151053_, (ItemLike)GItems.RAW_SILVER.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42417_, (ItemLike)GItems.SILVER_INGOT.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42587_, (ItemLike)GItems.SILVER_NUGGET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151049_, (ItemLike)GItems.ALLURITE_SHARD.get(), (ItemLike)GItems.LUMIERE_SHARD.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256791_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50489_, (ItemLike)GBlocks.CHANDELIER.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50625_, (ItemLike)GBlocks.COMBUSTION_TABLE.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50724_, (ItemLike)GBlocks.MONSTROMETER.get(), (ItemLike)GBlocks.WARPED_ANCHOR.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256776_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50125_, (ItemLike)GBlocks.LICHEN_MOSS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50073_, (ItemLike)GBlocks.BOWL_LICHEN.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50128_, (ItemLike)GBlocks.LICHEN_SHELF.get(), (ItemLike)GBlocks.LICHEN_ROOTS.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256839_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151079_, (ItemLike)GItems.LICHEN_CORDYCEPS.get(), (ItemLike)GItems.GOLDEN_LICHEN_CORDYCEPS.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256731_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42639_, (ItemLike)GItems.SPARKLE_SPAWN_EGG.get(), (ItemLike)GItems.SPECTRE_SPAWN_EGG.get(), (ItemLike)GItems.SPECTERPILLAR_SPAWN_EGG.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256869_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42524_, (ItemLike)GItems.BAROMETER.get());
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42450_, (ItemLike)GItems.GLOW_FLARE.get(), (ItemLike)GItems.SPECTRE_FLARE.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256797_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42467_, (ItemLike)GItems.STERLING_HELMET.get(), (ItemLike)GItems.STERLING_CHESTPLATE.get(), (ItemLike)GItems.STERLING_LEGGINGS.get(), (ItemLike)GItems.STERLING_BOOTS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42654_, (ItemLike)GItems.STERLING_HORSE_ARMOR.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41996_, (ItemLike)GItems.SILVER_BOMB.get());
        }
    }

    @SubscribeEvent
    public static void loadEntityShader(RegisterEntitySpectatorShadersEvent event) {
        event.register((EntityType)GEntityTypes.SPECTRE.get(), Galosphere.id("shaders/post/spectre.json"));
        event.register((EntityType)GEntityTypes.SPECTATOR_VISION.get(), Galosphere.id("shaders/post/spectre.json"));
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        HorseRenderer horseRenderer = (HorseRenderer)event.getRenderer(EntityType.f_20457_);
        if (horseRenderer == null) {
            return;
        }
        horseRenderer.m_115326_((RenderLayer)new HorseBannerLayer((RenderLayerParent<Horse, HorseModel<Horse>>)horseRenderer));
        event.getSkins().forEach(skin -> {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(skin);
            if (playerRenderer == null) {
                return;
            }
            playerRenderer.m_115326_(new BannerLayer(playerRenderer));
        });
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(GModelLayers.SPARKLE, SparkleModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.STERLING_HELMET, SterlingArmorModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.SPECTRE, SpectreModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.SPECTERPILLAR, SpecterpillarModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.GILDED_BEADS, GildedBeadsRenderer::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.BERSERKER, BerserkerModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.PRESERVED, PreservedModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.PINK_SALT_PILLAR, PinkSaltPillarModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)GEntityTypes.SPARKLE.get(), SparkleRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.SILVER_BOMB.get(), context -> new ThrownItemRenderer(context, 1.5f, false));
        event.registerEntityRenderer((EntityType)GEntityTypes.SPECTRE.get(), SpectreRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.GLOW_FLARE.get(), ThrowableLaunchedProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.SPECTRE_FLARE.get(), ThrowableLaunchedProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.SPECTERPILLAR.get(), SpecterpillarRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.SPECTATOR_VISION.get(), SpectatorVisionRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.BERSERKER.get(), BerserkerRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.PRESERVED.get(), PreservedRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.PINK_SALT_PILLAR.get(), PinkSaltPillarRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.PINK_SALT_SHARD.get(), PinkSaltShardRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)GBlockEntityTypes.SHADOW_FRAME.get(), ShadowFrameBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)GBlockEntityTypes.GILDED_BEADS.get(), GildedBeadsRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)GParticleTypes.SILVER_BOMB.get(), (ParticleProvider)new SilverBombProvider());
        event.registerSpriteSet((ParticleType)GParticleTypes.WARPED.get(), WarpedProvider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.ALLURITE_RAIN.get(), CrystalRainParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.LUMIERE_RAIN.get(), CrystalRainParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.AMETHYST_RAIN.get(), CrystalRainParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.AURA_RINGER_INDICATOR.get(), IndicatorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.SPECTATE_ORB.get(), SpectateOrbParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.PINK_SALT_FALLING_DUST.get(), PinkSaltFallingDustProvider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.IMPACT.get(), ImpactParticle.Provider::new);
    }
}

