/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SilverBalanceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)SilverBalanceBlock.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)SilverBalanceBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), (BooleanOp)BooleanOp.f_82695_);

    public SilverBalanceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction == Direction.UP) {
            levelAccessor.m_186460_(blockPos, (Block)this, 2);
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        this.updateNeighbours((Level)serverLevel, blockPos);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        this.updateNeighbours(level, blockPos);
    }

    private void updateNeighbours(Level level, BlockPos blockPos) {
        level.m_46672_(blockPos, (Block)this);
        level.m_46672_(blockPos.m_7495_(), (Block)this);
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        BlockState state = blockGetter.m_8055_(blockPos.m_7494_());
        return this.calculateOutputSignal(state);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        BlockState state = blockGetter.m_8055_(blockPos.m_7494_());
        return this.calculateOutputSignal(state);
    }

    private int calculateOutputSignal(BlockState blockState) {
        Block block = blockState.m_60734_();
        float destroyTime = block.m_155943_();
        boolean flag = !blockState.m_60795_() && blockState.m_60819_().m_76178_();
        int output = destroyTime < 0.0f ? 0 : (int)Math.min(15.0f, Math.max(1.0f, destroyTime) * 2.0f);
        return flag ? output : 0;
    }
}

