/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.blocks.blockentities.ShadowFrameBlockEntity;
import org.jetbrains.annotations.Nullable;

public class ShadowFrameBlock
extends BaseEntityBlock {
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public ShadowFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level world = blockPlaceContext.m_43725_();
        BlockPos pos = blockPlaceContext.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(world.m_276867_(pos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (level.f_46443_) {
            return;
        }
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(blockPos))), 2);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public float m_5880_(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.m_61143_((Property)FILLED)).booleanValue() && (blockEntity = blockGetter.m_7702_(blockPos)) instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            return shadowFrameBlockEntity.getCopiedState().m_60625_(player, blockGetter, blockPos);
        }
        return super.m_5880_(blockState, player, blockGetter, blockPos);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)FILLED) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public boolean m_6104_(BlockState blockState, BlockState blockState2, Direction direction) {
        if (blockState2.m_60713_((Block)this) && !((Boolean)blockState2.m_61143_((Property)FILLED)).booleanValue()) {
            return true;
        }
        return super.m_6104_(blockState, blockState2, direction);
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.m_61143_((Property)FILLED)).booleanValue() && (blockEntity = blockGetter.m_7702_(blockPos)) instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            BlockState copiedState = shadowFrameBlockEntity.getCopiedState();
            return copiedState.m_60734_().m_7397_(blockGetter, blockPos, copiedState);
        }
        return super.m_7397_(blockGetter, blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockItem blockItem;
        ItemStack stack = player.m_21120_(interactionHand);
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(player, interactionHand, stack, blockHitResult);
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() == this) {
            return InteractionResult.FAIL;
        }
        item = level.m_7702_(blockPos);
        if (item instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)item;
            if (stack.m_41720_() instanceof HoneycombItem && !shadowFrameBlockEntity.isWaxed()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, stack);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
                level.m_5898_(player, 3003, blockPos, 0);
                shadowFrameBlockEntity.setWaxed(true);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (shadowFrameBlockEntity.isWaxed()) {
                return InteractionResult.FAIL;
            }
            if (!((Boolean)blockState.m_61143_((Property)FILLED)).booleanValue()) {
                BlockItem blockItem2;
                Block block;
                BlockState stateForPlacement;
                Item item2 = stack.m_41720_();
                if (item2 instanceof BlockItem && this.canBeFramed(level, blockPlaceContext, stateForPlacement = (block = (blockItem2 = (BlockItem)item2).m_40614_()).m_5573_(blockPlaceContext))) {
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    level.m_5594_(null, blockPos, stateForPlacement.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    shadowFrameBlockEntity.interact(stateForPlacement, level, blockPos, blockState);
                    return InteractionResult.SUCCESS;
                }
            } else if (stack.m_41619_()) {
                if (!level.f_46443_) {
                    level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)), 2);
                    level.m_5594_(null, blockPos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)shadowFrameBlockEntity.getCopiedState().m_60734_().m_5456_()));
                }
                shadowFrameBlockEntity.setCopiedState(Blocks.f_50016_.m_49966_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    private boolean canBeFramed(Level level, BlockPlaceContext blockPlaceContext, BlockState stateForPlacement) {
        BlockPos clickedPos = blockPlaceContext.m_8083_();
        return stateForPlacement != null && !(stateForPlacement.m_60734_() instanceof EntityBlock) && Block.m_49916_((VoxelShape)stateForPlacement.m_60808_((BlockGetter)level, clickedPos));
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return (Boolean)state.m_61143_((Property)FILLED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FILLED, WATERLOGGED, LEVEL, POWERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ShadowFrameBlockEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.m_61143_((Property)FILLED)).booleanValue() && (blockEntity = blockGetter.m_7702_(blockPos)) instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            return shadowFrameBlockEntity.getCopiedState().m_60651_(blockGetter, blockPos, collisionContext);
        }
        return super.m_5940_(blockState, blockGetter, blockPos, collisionContext);
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)POWERED) == false ? Shapes.m_83040_() : blockState.m_60808_(blockGetter, blockPos);
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        List drops = super.m_49635_(blockState, builder);
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof ShadowFrameBlockEntity) {
            ShadowFrameBlockEntity shadowFrameBlockEntity = (ShadowFrameBlockEntity)blockEntity;
            drops.addAll(shadowFrameBlockEntity.getCopiedState().m_287290_(builder));
        }
        return drops;
    }
}

