/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.orcinus.galosphere.blocks.blockentities.MonstrometerBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class MonstrometerBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty CHARGED = BooleanProperty.m_61465_((String)"charged");

    public MonstrometerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (!level.f_46443_) {
            boolean flag;
            boolean bl2 = flag = (Boolean)blockState.m_61143_((Property)CHARGED) != false && (Boolean)blockState.m_61143_((Property)ACTIVE) == false;
            if (flag == level.m_276867_(blockPos)) {
                if (!flag) {
                    return;
                }
                MonstrometerBlock.activate(blockState, level, blockPos);
            }
        }
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        BlockEntity blockEntity;
        if (((Boolean)blockState.m_61143_((Property)ACTIVE)).booleanValue() && (blockEntity = level.m_7702_(blockPos)) instanceof MonstrometerBlockEntity) {
            MonstrometerBlockEntity monstrometerBlockEntity = (MonstrometerBlockEntity)blockEntity;
            return monstrometerBlockEntity.getRedstoneSignal();
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE}).m_61104_(new Property[]{CHARGED});
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        float value = super.m_5880_(state, player, getter, pos);
        return MonstrometerBlock.isActive(state) ? value / 25.0f : value;
    }

    public static boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE);
    }

    public static boolean isCharged(BlockState state) {
        return (Boolean)state.m_61143_((Property)CHARGED);
    }

    public static boolean isUnsafe(Level world, BlockPos pos) {
        return world.m_45517_(LightLayer.BLOCK, pos) == 0;
    }

    public static List<BlockPos> getIndicatedBlocks(BlockPos origin, Predicate<BlockPos> predicate) {
        int radius = 16;
        int height = 6;
        ArrayList list = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    if (x * x + z * z > radius * radius) continue;
                    list.add(origin.m_7918_(x, y, z));
                }
            }
        }
        return list.stream().filter(predicate).toList();
    }

    public static int getParticleViewRange() {
        return 12;
    }

    public static void activate(BlockState state, Level world, BlockPos pos) {
        world.m_186460_(pos, state.m_60734_(), 600);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        world.m_5594_(null, pos, (SoundEvent)GSoundEvents.MONSTROMETER_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_46672_(pos, state.m_60734_());
    }

    public static void deactivate(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(false)), 3);
        world.m_5594_(null, pos, (SoundEvent)GSoundEvents.MONSTROMETER_DEACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void setCharged(BlockState state, Level world, BlockPos pos) {
        world.m_7731_(pos, (BlockState)state.m_61122_((Property)CHARGED), 2);
        world.m_5594_(null, pos, (SoundEvent)GSoundEvents.MONSTROMETER_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(((Block)GBlocks.LUMIERE_BLOCK.get()).m_5456_())) {
            if (!MonstrometerBlock.isCharged(state)) {
                MonstrometerBlock.setCharged(state, world, pos);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                return InteractionResult.SUCCESS;
            }
        } else if (MonstrometerBlock.isCharged(state) && !MonstrometerBlock.isActive(state)) {
            MonstrometerBlock.activate(state, world, pos);
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (MonstrometerBlock.isActive(state)) {
            MonstrometerBlock.deactivate(state, (Level)world, pos);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MonstrometerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> te) {
        return !world.f_46443_ ? MonstrometerBlock.m_152132_(te, (BlockEntityType)((BlockEntityType)GBlockEntityTypes.MONSTROMETER.get()), MonstrometerBlockEntity::tick) : null;
    }
}

