/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChandelierBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> VERTICAL_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = ChandelierBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final Function<BlockState, VoxelShape> FUNCTION = blockState -> blockState.m_61143_(VERTICAL_DIRECTION) == Direction.DOWN ? ChandelierBlock.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0) : ChandelierBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public ChandelierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(VERTICAL_DIRECTION, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6104_(BlockState blockState, BlockState blockState2, Direction direction) {
        return blockState.m_61143_(HALF) != DoubleBlockHalf.LOWER;
    }

    public static int getLightEmission(BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? 15 : 0;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        boolean flag1;
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)blockState.m_61143_(HALF);
        Direction verticalDirection = (Direction)blockState.m_61143_(VERTICAL_DIRECTION);
        Direction oppositeDirection = verticalDirection.m_122424_();
        boolean flag = !blockState.m_60710_((LevelReader)levelAccessor, blockPos) && half == DoubleBlockHalf.LOWER && direction == verticalDirection.m_122424_();
        boolean bl = flag1 = half == DoubleBlockHalf.UPPER && !levelAccessor.m_8055_(blockPos.m_121945_(oppositeDirection)).m_60713_((Block)this);
        if (flag || flag1) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Direction direction = blockPlaceContext.m_151260_().m_122424_();
        if (blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_121945_(direction)).m_60629_(blockPlaceContext)) {
            return ChandelierBlock.copyWaterloggedFrom((LevelReader)level, blockPos, (BlockState)this.m_49966_().m_61124_(VERTICAL_DIRECTION, (Comparable)direction));
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        Direction verticalDirection = (Direction)blockState.m_61143_(VERTICAL_DIRECTION);
        BlockPos blockPos2 = blockPos.m_121945_(verticalDirection);
        level.m_7731_(blockPos2, ChandelierBlock.copyWaterloggedFrom((LevelReader)level, blockPos2, (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_(VERTICAL_DIRECTION, (Comparable)verticalDirection)), 3);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.m_61143_(VERTICAL_DIRECTION);
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockState2 = levelReader.m_8055_(blockPos.m_121945_(direction.m_122424_()));
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        }
        return Block.m_49863_((LevelReader)levelReader, (BlockPos)blockPos.m_121945_(direction.m_122424_()), (Direction)direction);
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelReader.m_46801_(blockPos)));
        }
        return blockState;
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                ChandelierBlock.preventCreativeDropFromBottomPart(level, blockPos, blockState, player);
            } else {
                ChandelierBlock.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, Blocks.f_50016_.m_49966_(), blockEntity, itemStack);
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockPos blockPos2;
        BlockState blockState2;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState2 = level.m_8055_(blockPos2 = blockPos.m_121945_(((Direction)blockState.m_61143_(VERTICAL_DIRECTION)).m_122424_()))).m_60713_(blockState.m_60734_()) && blockState2.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState3 = blockState2.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState2.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockPos2, blockState3, 35);
            level.m_5898_(player, 2001, blockPos2, Block.m_49956_((BlockState)blockState2));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VERTICAL_DIRECTION, WATERLOGGED, HALF});
    }

    public long m_7799_(BlockState blockState, BlockPos blockPos) {
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)blockPos.m_6625_(blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)blockPos.m_123343_());
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? FUNCTION.apply(blockState) : SHAPE;
    }
}

