/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.config;

import com.google.gson.JsonElement;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.ConfigTypeEntry;
import dev.xkmc.l2serial.serialization.codec.JsonCodec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;

public abstract class ConfigDataProvider
implements DataProvider {
    private final DataGenerator generator;
    private final String name;
    private final Map<String, ConfigEntry<?>> map = new HashMap();

    public ConfigDataProvider(DataGenerator generator, String name) {
        this.generator = generator;
        this.name = name;
    }

    public abstract void add(Collector var1);

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path folder = this.generator.getPackOutput().m_245114_();
        this.add(new Collector(this.map));
        ArrayList list = new ArrayList();
        this.map.forEach((k, v) -> {
            JsonElement elem = v.serialize();
            if (elem != null) {
                Path path = folder.resolve(k + ".json");
                list.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)elem, (Path)path));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return this.name;
    }

    public record Collector(Map<String, ConfigEntry<?>> map) {
        public <T extends BaseConfig> void add(ConfigTypeEntry<T> type, ResourceLocation id, T config) {
            this.map.put(type.asPath(id), new ConfigEntry<T>(type, id, config));
        }
    }

    public record ConfigEntry<T extends BaseConfig>(ConfigTypeEntry<T> type, ResourceLocation id, T config) {
        @Nullable
        public JsonElement serialize() {
            return JsonCodec.toJson(this.config, this.type.cls());
        }
    }
}

