/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.overlay;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public abstract class SideBar<S extends Signature<S>> {
    protected final float max_time;
    protected final float max_ease;
    @Nullable
    protected S prev;
    protected float idle = 0.0f;
    protected float ease_time = 0.0f;
    protected float prev_time = -1.0f;

    public SideBar(float duration, float ease) {
        this.max_time = duration;
        this.max_ease = ease;
    }

    public abstract S getSignature();

    public abstract boolean isScreenOn();

    protected boolean isOnHold() {
        return Minecraft.m_91087_().f_91066_.f_92090_.m_90857_();
    }

    protected boolean ease(float current_time) {
        if (!this.isScreenOn()) {
            this.prev = null;
            this.idle = this.max_time;
            this.ease_time = 0.0f;
            this.prev_time = -1.0f;
            return false;
        }
        float time_diff = this.prev_time < 0.0f ? 0.0f : current_time - this.prev_time;
        this.prev_time = current_time;
        S signature = this.getSignature();
        this.idle = signature.shouldRefreshIdle(this, this.prev) || this.isOnHold() ? 0.0f : (this.idle += time_diff);
        this.prev = signature;
        if (this.idle < this.max_time) {
            if (this.ease_time < this.max_ease) {
                this.ease_time += time_diff;
                if (this.ease_time > this.max_ease) {
                    this.ease_time = this.max_ease;
                }
            }
        } else if (this.ease_time > 0.0f) {
            this.ease_time -= time_diff;
            if (this.ease_time < 0.0f) {
                this.ease_time = 0.0f;
            }
        }
        return this.ease_time > 0.0f;
    }

    public boolean isRendering() {
        return this.isScreenOn() && this.ease_time > 0.0f;
    }

    protected int getXOffset(int width) {
        return 0;
    }

    protected int getYOffset(int height) {
        return 0;
    }

    public static interface Signature<S extends Signature<S>> {
        public boolean shouldRefreshIdle(SideBar<?> var1, @Nullable S var2);
    }

    public record IntSignature(int val) implements Signature<IntSignature>
    {
        @Override
        public boolean shouldRefreshIdle(SideBar<?> sideBar, @Nullable IntSignature old) {
            return old == null || this.val != old.val;
        }
    }
}

