/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config.formats;

import com.hypherionmc.craterlib.core.config.formats.AbstractConfigFormat;
import java.io.File;
import shadow.hypherionmc.moonconfig.core.CommentedConfig;
import shadow.hypherionmc.moonconfig.core.Config;
import shadow.hypherionmc.moonconfig.core.UnmodifiableConfig;
import shadow.hypherionmc.moonconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.moonconfig.core.file.CommentedFileConfig;

public class TomlConfigFormat<S>
extends AbstractConfigFormat<S> {
    public TomlConfigFormat(File configPath, Runnable onSave) {
        super(configPath, onSave);
    }

    @Override
    public void saveConfig(S conf) {
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.getConfigPath()).sync().build();
        converter.toConfig(conf, (Config)config);
        config.save();
        this.getOnSave().run();
    }

    @Override
    public S readConfig(S conf) {
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.getConfigPath()).sync().build();
        config.load();
        converter.toObject((UnmodifiableConfig)config, conf);
        return conf;
    }

    @Override
    public void migrateConfig(S conf) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.getConfigPath()).build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.getConfigPath()).sync().build();
        config.load();
        if (this.wasConfigChanged(config, newConfig)) {
            new ObjectConverter().toConfig(conf, (Config)newConfig);
            this.updateConfigValues(config, newConfig, newConfig, "");
            newConfig.save();
        }
        config.close();
        newConfig.close();
    }

    public void updateConfigValues(CommentedConfig oldConfig, CommentedConfig newConfig, CommentedConfig outputConfig, String subKey) {
        newConfig.valueMap().forEach((key, value) -> {
            String finalKey = subKey + (subKey.isEmpty() ? "" : ".") + key;
            if (value instanceof CommentedConfig) {
                CommentedConfig commentedConfig = (CommentedConfig)value;
                this.updateConfigValues(oldConfig, commentedConfig, outputConfig, finalKey);
            } else {
                outputConfig.set(finalKey, oldConfig.contains(finalKey) ? oldConfig.get(finalKey) : value);
            }
        });
    }
}

