/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.rewind;

import com.hollingsworth.arsnouveau.api.spell.IContextAttachment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.rewind.IRewindCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class RewindAttachment
implements IContextAttachment {
    public static final ResourceLocation ID = new ResourceLocation("ars_nouveau", "rewind");
    private final Map<Long, List<IRewindCallback>> rewindEvents = new HashMap<Long, List<IRewindCallback>>();
    private long lockedTime = 0L;

    public void addRewindEvents(long gameTime, Collection<IRewindCallback> callbacks) {
        if (this.lockedTime == gameTime) {
            return;
        }
        this.rewindEvents.computeIfAbsent(gameTime, k -> new ArrayList()).addAll(callbacks);
    }

    public void addRewindEvent(long gameTime, IRewindCallback callback) {
        if (this.lockedTime == gameTime) {
            return;
        }
        this.rewindEvents.computeIfAbsent(gameTime, k -> new ArrayList()).add(callback);
    }

    public static RewindAttachment get(SpellContext context) {
        return context.getOrCreateAttachment(ID, new RewindAttachment());
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public Map<Long, List<IRewindCallback>> getRewindEvents() {
        return this.rewindEvents;
    }

    @Nullable
    public List<IRewindCallback> getForTime(long gameTime) {
        return this.rewindEvents.get(gameTime);
    }

    public long setLockedTime(long lockedTime) {
        this.lockedTime = lockedTime;
        return lockedTime;
    }

    public long getLockedTime() {
        return this.lockedTime;
    }
}

