/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.medievalorigins.Constants;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityAction;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.ModList;

public class SpellDamageAction
extends BiEntityAction<Configuration> {
    private static final Map<String, String> SCHOOL_TRANSLATION_MAP = new HashMap<String, String>();

    public SpellDamageAction() {
        super(Configuration.CODEC);
    }

    public void execute(Configuration configuration, Entity actor, Entity target) {
        if (!(actor instanceof LivingEntity) || target == null) {
            return;
        }
        float baseDamage = configuration.base();
        String magicSchoolStr = configuration.magicSchool();
        if (ModList.get().isLoaded("irons_spellbooks")) {
            String translatedSchool;
            ResourceLocation schoolResourceLocation = new ResourceLocation((String)(magicSchoolStr.contains(":") ? magicSchoolStr : "irons_spellbooks:" + magicSchoolStr));
            SchoolType magicSchool = SchoolRegistry.getSchool((ResourceLocation)schoolResourceLocation);
            if (magicSchool == null && (translatedSchool = SCHOOL_TRANSLATION_MAP.get(magicSchoolStr)) != null) {
                schoolResourceLocation = new ResourceLocation((String)(translatedSchool.contains(":") ? translatedSchool : "irons_spellbooks:" + translatedSchool));
                magicSchool = SchoolRegistry.getSchool((ResourceLocation)schoolResourceLocation);
            }
            if (magicSchool != null) {
                double spellPower = magicSchool.getPowerFor((LivingEntity)actor);
                baseDamage = (float)((double)baseDamage + spellPower * (double)configuration.scalingFactor());
            } else {
                Constants.LOG.info("No valid Magic School found for type " + magicSchoolStr);
            }
        }
        DamageSource source = MiscUtil.createDamageSource((DamageSources)actor.m_269291_(), (DamageSourceDescription)configuration.source().orElse(null), (ResourceKey)configuration.damageType().orElse(null), (Entity)actor);
        target.m_6469_(source, baseDamage);
    }

    static {
        SCHOOL_TRANSLATION_MAP.put("frost", "ice");
        SCHOOL_TRANSLATION_MAP.put("healing", "holy");
        SCHOOL_TRANSLATION_MAP.put("arcane", "ender");
        SCHOOL_TRANSLATION_MAP.put("soul", "blood");
    }

    public static class Configuration
    implements IDynamicFeatureConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("base").forGetter(Configuration::base), (App)Codec.STRING.fieldOf("magic_school").forGetter(Configuration::magicSchool), (App)Codec.FLOAT.fieldOf("scaling_factor").forGetter(Configuration::scalingFactor), (App)CalioCodecHelper.optionalField((Codec)ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, (String)"source").forGetter(Configuration::source), (App)CalioCodecHelper.optionalField((Codec)SerializableDataTypes.DAMAGE_TYPE, (String)"damage_type").forGetter(Configuration::damageType)).apply((Applicative)instance, Configuration::new));
        private final float base;
        private final String magicSchool;
        private final float scalingFactor;
        private final Optional<DamageSourceDescription> source;
        private final Optional<ResourceKey<DamageType>> damageType;

        public Configuration(float base, String magicSchool, float scalingFactor, Optional<DamageSourceDescription> source, Optional<ResourceKey<DamageType>> damageType) {
            this.base = base;
            this.magicSchool = magicSchool;
            this.scalingFactor = scalingFactor;
            this.source = source;
            this.damageType = damageType;
        }

        public float base() {
            return this.base;
        }

        public String magicSchool() {
            return this.magicSchool;
        }

        public float scalingFactor() {
            return this.scalingFactor;
        }

        public Optional<DamageSourceDescription> source() {
            return this.source;
        }

        public Optional<ResourceKey<DamageType>> damageType() {
            return this.damageType;
        }
    }
}

