/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.object.SBLShufflingList;
import org.jetbrains.annotations.Nullable;

public final class AllApplicableBehaviours<E extends LivingEntity>
extends GroupBehaviour<E> {
    public AllApplicableBehaviours(Pair<ExtendedBehaviour<? super E>, Integer> ... behaviours) {
        super(behaviours);
    }

    public AllApplicableBehaviours(ExtendedBehaviour<? super E> ... behaviours) {
        super(behaviours);
    }

    @Override
    protected boolean doStartCheck(ServerLevel level, E entity, long gameTime) {
        if (!(this.cooldownFinishedAt <= gameTime && this.m_22543_(entity) && this.startCondition.test(entity) && this.m_6114_(level, entity))) {
            return false;
        }
        this.runningBehaviour = this.pickBehaviour(level, entity, gameTime, this.behaviours);
        return this.runningBehaviour != null;
    }

    @Override
    @Nullable
    protected ExtendedBehaviour<? super E> pickBehaviour(ServerLevel level, E entity, long gameTime, SBLShufflingList<ExtendedBehaviour<? super E>> extendedBehaviours) {
        ExtendedBehaviour<E> lastSuccessfulBehaviour = null;
        for (ExtendedBehaviour<E> behaviour : extendedBehaviours) {
            if (!behaviour.m_22554_(level, entity, gameTime)) continue;
            lastSuccessfulBehaviour = behaviour;
        }
        return lastSuccessfulBehaviour;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        boolean stillOperational = false;
        for (ExtendedBehaviour behaviour : this.behaviours) {
            stillOperational |= behaviour.m_22536_() == Behavior.Status.RUNNING && behaviour.m_6737_((ServerLevel)entity.m_9236_(), entity, entity.m_9236_().m_46467_());
        }
        return stillOperational;
    }

    @Override
    protected boolean m_7773_(long gameTime) {
        boolean timedOut = true;
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.m_22536_() != Behavior.Status.RUNNING || behaviour.m_7773_(gameTime)) continue;
            timedOut = false;
        }
        return timedOut;
    }

    @Override
    protected void m_6725_(ServerLevel level, E owner, long gameTime) {
        boolean stillRunning = false;
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.m_22536_() != Behavior.Status.RUNNING) continue;
            behaviour.m_22558_(level, (LivingEntity)owner, gameTime);
            if (behaviour.m_22536_() == Behavior.Status.STOPPED) continue;
            stillRunning = true;
        }
        if (!stillRunning) {
            this.m_22562_(level, (LivingEntity)owner, gameTime);
        }
    }

    @Override
    protected void m_6732_(ServerLevel level, E entity, long gameTime) {
        this.cooldownFinishedAt = gameTime + (long)((Integer)this.cooldownProvider.apply(entity)).intValue();
        this.taskStopCallback.accept(entity);
        this.stop(entity);
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.m_22536_() != Behavior.Status.RUNNING) continue;
            behaviour.m_22562_(level, (LivingEntity)entity, gameTime);
        }
    }

    @Override
    public Behavior.Status m_22536_() {
        for (ExtendedBehaviour behaviour : this.behaviours) {
            if (behaviour.m_22536_() != Behavior.Status.RUNNING) continue;
            return Behavior.Status.RUNNING;
        }
        return Behavior.Status.STOPPED;
    }

    @Override
    public String toString() {
        Set activeBehaviours = this.behaviours.stream().filter(behaviorControl -> behaviorControl.m_22536_() == Behavior.Status.RUNNING).collect(Collectors.toSet());
        return "(" + ((Object)((Object)this)).getClass().getSimpleName() + "): " + activeBehaviours;
    }
}

