/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dev.limonblaze.originsclasses.common.tag.OriginsClassesItemTags;
import dev.limonblaze.originsclasses.core.mixin.accessor.minecraft.LootTableAccessor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MerchantHelper
extends SimplePreparableReloadListener<Void> {
    private static MerchantHelper INSTANCE;
    private final LootDataManager lootTables;
    public Set<Item> obtainableItems = ImmutableSet.of();
    public Set<Item> blacklistItems = ImmutableSet.of();

    public MerchantHelper(LootDataManager lootTables) {
        this.lootTables = lootTables;
    }

    protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        return null;
    }

    protected void apply(Void nothing, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ResourceLocation id : this.lootTables.m_278706_(LootDataType.f_278413_)) {
            List<LootPool> pools = ((LootTableAccessor)this.lootTables.m_278676_(id)).getPools();
            LinkedList<LootPoolEntryContainer> entryQueue = new LinkedList<LootPoolEntryContainer>();
            for (LootPool pool : pools) {
                LootPoolEntryContainer[] entries = pool.f_79023_;
                entryQueue.addAll(Arrays.asList(entries));
            }
            while (!entryQueue.isEmpty()) {
                LootPoolEntryContainer entry = (LootPoolEntryContainer)entryQueue.remove();
                if (entry instanceof LootItem) {
                    LootItem li = (LootItem)entry;
                    builder.add((Object)li.f_79564_);
                    continue;
                }
                if (entry instanceof TagEntry) {
                    TagEntry te = (TagEntry)entry;
                    Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(te.f_79821_).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
                    continue;
                }
                if (!(entry instanceof CompositeEntryBase)) continue;
                CompositeEntryBase ceb = (CompositeEntryBase)entry;
                entryQueue.addAll(Arrays.asList(ceb.f_79428_));
            }
        }
        this.obtainableItems = builder.build();
        this.blacklistItems = ForgeRegistries.ITEMS.tags().getTag(OriginsClassesItemTags.MERCHANT_BLACKLIST).stream().collect(Collectors.toUnmodifiableSet());
    }

    public Item randomObtainableItem(RandomSource random, Set<Item> exclude) {
        Item[] obtainables = exclude.isEmpty() ? this.obtainableItems.toArray(new Item[0]) : (Item[])Sets.difference(this.obtainableItems, exclude).toArray((Object[])new Item[0]);
        return obtainables.length > 0 ? obtainables[random.m_188503_(obtainables.length)] : Items.f_41852_;
    }

    public static ItemStack randomEnchantedItemStack(Item item, RandomSource random, float chance, int power) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (item.m_8120_(stack) && random.m_188501_() < chance) {
            EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)stack, (int)(1 + random.m_188503_(power)), (boolean)random.m_188499_());
        }
        return stack;
    }

    public static MerchantHelper instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("MerchantHelper haven't been initialized yet!");
        }
        return INSTANCE;
    }

    @SubscribeEvent
    public static void addSelfToReloadListeners(AddReloadListenerEvent event) {
        INSTANCE = new MerchantHelper(event.getServerResources().m_278801_());
        event.addListener((PreparableReloadListener)INSTANCE);
    }
}

