/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.SendPlayerPositionPacket;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public enum LongRangePlayerTracker {
    INSTANCE;

    private long lastTick = 0L;
    private final Table<UUID, UUID, BlockPos> trackingMap = HashBasedTable.create();

    public void tick(MinecraftServer server) {
        int interval = (Integer)FTBChunksWorldConfig.LONG_RANGE_TRACKER_INTERVAL.get();
        if (interval != 0 && (long)server.m_129921_() - this.lastTick > (long)interval) {
            this.lastTick = server.m_129921_();
            List players = server.m_6846_().m_11314_();
            int maxDistSq = server.m_6846_().m_11312_() * server.m_6846_().m_11312_() * 256;
            players.forEach(p1 -> p1.m_9236_().m_6907_().forEach(p2a -> {
                if (p2a instanceof ServerPlayer) {
                    ServerPlayer p2 = (ServerPlayer)p2a;
                    if (this.shouldTrack((ServerPlayer)p1, p2, maxDistSq)) {
                        BlockPos lastPos = (BlockPos)this.trackingMap.get((Object)p1.m_20148_(), (Object)p2.m_20148_());
                        if (lastPos == null || p2.m_20183_().m_123331_((Vec3i)lastPos) > 16.0) {
                            new SendPlayerPositionPacket(p2, p2.m_20183_()).sendTo((ServerPlayer)p1);
                            this.trackingMap.put((Object)p1.m_20148_(), (Object)p2.m_20148_(), (Object)p2.m_20183_());
                        }
                    } else if (this.trackingMap.contains((Object)p1.m_20148_(), (Object)p2.m_20148_())) {
                        new SendPlayerPositionPacket(p2, null).sendTo((ServerPlayer)p1);
                        this.trackingMap.remove((Object)p1.m_20148_(), (Object)p2.m_20148_());
                    }
                }
            }));
        }
    }

    public void stopTracking(ServerPlayer player) {
        if (player.m_20194_() == null) {
            return;
        }
        HashMap<UUID, UUID> toRemove = new HashMap<UUID, UUID>();
        for (UUID trackingId2 : this.trackingMap.rowKeySet()) {
            if (!this.trackingMap.contains((Object)trackingId2, (Object)player.m_20148_())) continue;
            toRemove.put(trackingId2, player.m_20148_());
        }
        toRemove.forEach((trackingId, disconnectedId) -> {
            ServerPlayer trackingPlayer = player.m_20194_().m_6846_().m_11259_(trackingId);
            if (trackingPlayer != null) {
                new SendPlayerPositionPacket(player, null).sendTo(trackingPlayer);
            }
            this.trackingMap.remove(trackingId, disconnectedId);
        });
    }

    private boolean shouldTrack(ServerPlayer p1, ServerPlayer p2, int maxDistSq) {
        if (p1 == p2 || p1.m_20280_((Entity)p2) < (double)maxDistSq) {
            return false;
        }
        if (((Boolean)FTBChunksWorldConfig.LOCATION_MODE_OVERRIDE.get()).booleanValue()) {
            return true;
        }
        ChunkTeamDataImpl p2Team = ClaimedChunkManagerImpl.getInstance().getOrCreateData(p2);
        return p2Team != null && p2Team.canPlayerUse(p1, FTBChunksProperties.LOCATION_MODE);
    }
}

