/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network.messages;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import ru.astemir.astemirlib.common.handler.EventEntity;
import ru.astemir.astemirlib.common.network.PacketArgument;

public class ClientMessageEntityEvent {
    private int entityId;
    private int eventId;
    private PacketArgument[] arguments;

    public ClientMessageEntityEvent(int entityId, int eventId, PacketArgument ... arguments) {
        this.entityId = entityId;
        this.eventId = eventId;
        this.arguments = arguments;
    }

    public static void encode(ClientMessageEntityEvent message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.eventId);
        buf.writeInt(message.arguments.length);
        for (PacketArgument argument : message.arguments) {
            argument.write(buf);
        }
    }

    public static ClientMessageEntityEvent decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int eventId = buf.readInt();
        int length = buf.readInt();
        PacketArgument[] arguments = new PacketArgument[length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PacketArgument.read(buf);
        }
        ClientMessageEntityEvent message = new ClientMessageEntityEvent(entityId, eventId, arguments);
        return message;
    }

    public static class Handler
    implements BiConsumer<ClientMessageEntityEvent, Supplier<NetworkEvent.Context>> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void accept(ClientMessageEntityEvent message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                EventEntity eventEntity;
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
                if (entity != null && entity instanceof EventEntity && (eventEntity = (EventEntity)entity).getClientLevelEventMap() != null) {
                    eventEntity.getClientLevelEventMap().handleEvent(entity, message.eventId, (Level)Minecraft.m_91087_().f_91073_, entity.m_20183_(), message.arguments);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

