/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.network.NetworkUtils;

public class PacketArgument {
    private Object value;
    private ArgumentType type;

    public PacketArgument(ArgumentType type, Object value) {
        this.value = value;
        this.type = type;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        switch (this.type) {
            case VEC3: {
                NetworkUtils.writeVec3(buf, this.asVec3());
                break;
            }
            case DOUBLE: {
                buf.writeDouble(this.asDouble());
                break;
            }
            case FLOAT: {
                buf.writeFloat(this.asFloat());
                break;
            }
            case INT: {
                buf.writeInt(this.asInt());
                break;
            }
            case STRING: {
                buf.m_130070_(this.asString());
                break;
            }
            case UUID: {
                buf.m_130077_(this.asUUID());
                break;
            }
            case COLOR: {
                NetworkUtils.writeColor(buf, this.asColor());
                break;
            }
            case NBT: {
                buf.m_130079_(this.asNBT());
                break;
            }
            case BOOL: {
                buf.writeBoolean(this.asBoolean());
                break;
            }
            case ITEMSTACK: {
                buf.writeItemStack(this.asItemStack(), false);
            }
        }
    }

    public static PacketArgument read(FriendlyByteBuf buf) {
        ArgumentType type = (ArgumentType)buf.m_130066_(ArgumentType.class);
        switch (type) {
            case INT: {
                return new PacketArgument(type, buf.readInt());
            }
            case DOUBLE: {
                return new PacketArgument(type, buf.readDouble());
            }
            case FLOAT: {
                return new PacketArgument(type, Float.valueOf(buf.readFloat()));
            }
            case STRING: {
                return new PacketArgument(type, buf.m_130277_());
            }
            case VEC3: {
                return new PacketArgument(type, NetworkUtils.readVec3(buf));
            }
            case UUID: {
                return new PacketArgument(type, buf.m_130259_());
            }
            case BOOL: {
                return new PacketArgument(type, buf.readBoolean());
            }
            case COLOR: {
                return new PacketArgument(type, NetworkUtils.readColor(buf));
            }
            case NBT: {
                return new PacketArgument(type, buf.m_130260_());
            }
            case ITEMSTACK: {
                return new PacketArgument(type, buf.m_130267_());
            }
        }
        return null;
    }

    public ItemStack asItemStack() {
        return (ItemStack)this.value;
    }

    public float asFloat() {
        return ((Float)this.value).floatValue();
    }

    public Vec3 asVec3() {
        return (Vec3)this.value;
    }

    public int asInt() {
        return (Integer)this.value;
    }

    public boolean asBoolean() {
        return (Boolean)this.value;
    }

    public String asString() {
        return (String)this.value;
    }

    public double asDouble() {
        return (Double)this.value;
    }

    public Color asColor() {
        return (Color)this.value;
    }

    public UUID asUUID() {
        return (UUID)this.value;
    }

    public CompoundTag asNBT() {
        return (CompoundTag)this.value;
    }

    public Object getValue() {
        return this.value;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public static PacketArgument create(ArgumentType type, Object value) {
        return new PacketArgument(type, value);
    }

    public static PacketArgument valVec3(Vec3 vec3) {
        return PacketArgument.create(ArgumentType.VEC3, vec3);
    }

    public static PacketArgument valNbt(CompoundTag tag) {
        return PacketArgument.create(ArgumentType.NBT, tag);
    }

    public static PacketArgument valItemStack(ItemStack itemStack) {
        return PacketArgument.create(ArgumentType.ITEMSTACK, itemStack);
    }

    public static PacketArgument valFloat(float value) {
        return PacketArgument.create(ArgumentType.FLOAT, Float.valueOf(value));
    }

    public static PacketArgument valDouble(double value) {
        return PacketArgument.create(ArgumentType.DOUBLE, value);
    }

    public static PacketArgument valInt(int value) {
        return PacketArgument.create(ArgumentType.INT, value);
    }

    public static PacketArgument valBool(boolean value) {
        return PacketArgument.create(ArgumentType.BOOL, value);
    }

    public static PacketArgument valStr(String value) {
        return PacketArgument.create(ArgumentType.STRING, value);
    }

    public static PacketArgument valUUID(UUID uuid) {
        return PacketArgument.create(ArgumentType.UUID, uuid);
    }

    public static enum ArgumentType {
        VEC3,
        FLOAT,
        DOUBLE,
        INT,
        STRING,
        UUID,
        COLOR,
        NBT,
        BOOL,
        ITEMSTACK;

    }
}

