/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.misc;

import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public abstract class ForgeRunLater {
    public static final Handler handler = new Handler();
    private long lifeTime = 0L;

    public ForgeRunLater runTaskLater(long delay) {
        ForgeRunLater runnable = this.create(delay);
        handler.add(runnable);
        return runnable;
    }

    protected ForgeRunLater create(long delay) {
        this.lifeTime = handler.getGlobalTicks() + delay;
        return this;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public abstract void run();

    @Mod.EventBusSubscriber(modid="astemirlib")
    public static class Handler {
        private CopyOnWriteArrayList<ForgeRunLater> timers = new CopyOnWriteArrayList();
        private static long globalTicks = 0L;

        public void add(ForgeRunLater runnable) {
            this.timers.add(runnable);
        }

        @SubscribeEvent
        public static void onTick(TickEvent.ServerTickEvent e) {
            if (e.phase == TickEvent.Phase.START) {
                ++globalTicks;
                for (ForgeRunLater runnable : ForgeRunLater.handler.timers) {
                    if (globalTicks < runnable.getLifeTime()) continue;
                    runnable.run();
                    ForgeRunLater.handler.timers.remove(runnable);
                }
            }
        }

        public static long getGlobalTicks() {
            return globalTicks;
        }
    }
}

