/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.InterpolationType;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float PI_HALF = 1.5707964f;
    public static final float PI_DOUBLE = (float)Math.PI * 2;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float STARTING_ANGLE = (float)Math.PI / 180;
    public static final float THREE_STARTING_ANGLE = 0.05235988f;
    public static final float EIGHT_STARTING_ANGLE = 0.13962634f;

    public static float abs(float value) {
        return Math.abs(value);
    }

    public static float rad(float angle) {
        return angle * (float)Math.PI / 180.0f;
    }

    public static float deg(float angle) {
        return angle * 180.0f / (float)Math.PI;
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static float cos(float value) {
        return (float)Math.cos(value);
    }

    public static float sin(float value) {
        return (float)Math.sin(value);
    }

    public static float acos(float value) {
        return (float)Math.acos(value);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float asin(float a) {
        return (float)Math.asin(a);
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float progressOfTime(long ticks, float value) {
        return (float)ticks % value / value;
    }

    public static float arrange(float value, float oldMin, float oldMax, float newMin, float newMax) {
        return (value - oldMin) / (oldMax - oldMin) * (newMax - newMin) + newMin;
    }

    public static float lerp(float a, float b, float t) {
        return (float)InterpolationType.LINEAR.interpolate(a, b, (double)t);
    }

    public static float rotLerp(float a, float b, float t) {
        return (float)InterpolationType.LINEAR.interpolateRot(a, b, (double)t);
    }

    public static float smooth(float a, float b, float t) {
        return (float)InterpolationType.CATMULLROM.interpolate(a, b, (double)t);
    }

    public static float rotSmooth(float a, float b, float t) {
        return (float)InterpolationType.CATMULLROM.interpolateRot(a, b, (double)t);
    }

    public static float triangleWave(float frequency, float amplitude, float t) {
        float period = 1.0f / frequency;
        float phase = t % period;
        float value = 2.0f * amplitude / period * phase;
        if (value > amplitude) {
            value = 2.0f * amplitude - value;
        }
        return value - amplitude;
    }

    public static float sinPositive(float frequency, float amplitude, float t) {
        return (float)(Math.abs(Math.sin(Math.PI * 2 * (double)frequency * (double)t)) * (double)amplitude);
    }

    public static float cosPositive(float frequency, float amplitude, float t) {
        return (float)(Math.abs(Math.sin(Math.PI * 2 * (double)frequency * (double)t)) * (double)amplitude);
    }

    public static float sinDecay(float frequency, float amplitude, float decayRate, float t) {
        return (float)(Math.sin(Math.PI * 2 * (double)frequency * (double)t) * (double)amplitude * Math.exp(-decayRate * t));
    }

    public static float cosDecay(float frequency, float amplitude, float decayRate, float t) {
        return (float)(Math.cos(Math.PI * 2 * (double)frequency * (double)t) * (double)amplitude * Math.exp(-decayRate * t));
    }

    public static float squareWave(float frequency, float amplitude, float t) {
        return Math.floor(2.0f * frequency * t) % 2.0 == 0.0 ? amplitude : -amplitude;
    }

    public static float sawtooth(float frequency, float amplitude, float t) {
        return (float)((double)(2.0f * amplitude) * ((double)(t * frequency) - Math.floor(t * frequency + 0.5f)));
    }

    public static float pulse(float frequency, float amplitude, float t) {
        return (float)(Math.sin(Math.PI * 2 * (double)frequency * (double)t) * (double)amplitude);
    }

    public static float damping(float dampingFactor, float amplitude, float t) {
        return (float)(Math.cos(Math.PI * 2 * (double)t) * Math.exp(-dampingFactor * t) * (double)amplitude);
    }

    public static float oscillation(float frequency, float amplitude, float t) {
        return (float)(Math.sin(Math.PI * 2 * (double)frequency * (double)t) * Math.cos(Math.PI * 2 * (double)frequency * (double)t) * (double)amplitude);
    }

    public static float acceleration(float power, float amplitude, float t) {
        return (float)(Math.pow(t, power) * (double)amplitude);
    }

    public static float easing(float amplitude, float t) {
        return (float)(Math.pow(t, 3.0) * (double)(amplitude - t * amplitude));
    }

    public static float shortestAngle(float a, float b) {
        return (b - a + 180.0f) % 360.0f - 180.0f;
    }

    public static float wrapRadians(float radians) {
        return MathUtils.rad(MathUtils.wrapDegrees(MathUtils.deg(radians)));
    }

    public static float wrapDegrees(float angle) {
        float f = angle % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static <T> boolean equalsApproxUniversal(T a, T b, float t) {
        if (a instanceof Number) {
            Number a1 = (Number)a;
            if (b instanceof Number) {
                Number b1 = (Number)b;
                return MathUtils.equalsApprox(a1.floatValue(), b1.floatValue(), t);
            }
        }
        if (a instanceof AVector2f) {
            AVector2f a1 = (AVector2f)a;
            if (b instanceof AVector2f) {
                AVector2f b1 = (AVector2f)b;
                return a1.equalsApprox(b1, t);
            }
        }
        if (a instanceof AVector3f) {
            AVector3f a1 = (AVector3f)a;
            if (b instanceof AVector3f) {
                AVector3f b1 = (AVector3f)b;
                return a1.equalsApprox(b1, t);
            }
        }
        if (a instanceof Color) {
            Color a1 = (Color)a;
            if (b instanceof Color) {
                Color b1 = (Color)b;
                return a1.equalsApprox(b1, t);
            }
        }
        return false;
    }

    public static boolean equalsApprox(float a, float b, float t) {
        float tolerance;
        float diff = Math.abs(b - a);
        return diff < (tolerance = t / 100.0f * b);
    }

    public static float floatSafe(float f) {
        if (Float.isNaN(f)) {
            return 0.0f;
        }
        return f;
    }

    public static double cosFromSin(double sin, double angle) {
        double cos = MathUtils.sqrt((float)(1.0 - sin * sin));
        double a = angle + 1.5707963705062866;
        double b = a - (double)((float)((int)(a / 6.2831854820251465)) * ((float)Math.PI * 2));
        if (b < 0.0) {
            b = 6.2831854820251465 + b;
        }
        if (b >= 3.1415927410125732) {
            return -cos;
        }
        return cos;
    }

    public static double eval(final String str) {
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < str.length()) {
                    return 0.0;
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    if (!this.eat(41)) {
                        return 0.0;
                    }
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(str.substring(startPos, this.pos));
                } else {
                    if (this.ch >= 97 && this.ch <= 122) {
                        double x2;
                        while (this.ch >= 97 && this.ch <= 122) {
                            this.nextChar();
                        }
                        String func = str.substring(startPos, this.pos);
                        if (this.eat(40)) {
                            x2 = this.parseExpression();
                            if (!this.eat(41)) {
                                return 0.0;
                            }
                        } else {
                            x2 = this.parseFactor();
                        }
                        if (func.equals("sqrt")) {
                            x2 = Math.sqrt(x2);
                        } else if (func.equals("sin")) {
                            x2 = Math.sin(Math.toRadians(x2));
                        } else if (func.equals("cos")) {
                            x2 = Math.cos(Math.toRadians(x2));
                        } else if (func.equals("tan")) {
                            x2 = Math.tan(Math.toRadians(x2));
                        }
                        return 0.0;
                    }
                    return 0.0;
                }
                if (this.eat(94)) {
                    x = Math.pow(x, this.parseFactor());
                }
                return x;
            }
        }.parse();
    }
}

