/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import java.util.function.Function;
import ru.astemir.astemirlib.common.math.MathUtils;

public enum EasingType {
    NONE(t -> t),
    IN(t -> t * t),
    OUT(t -> t * (2.0 - t)),
    IN_OUT(t -> {
        if (t < 0.5) {
            return 2.0 * t * t;
        }
        return -1.0 + (4.0 - 2.0 * t) * t;
    }),
    BACK_IN(t -> t * t * (2.70158 * t - 1.70158)),
    BACK_OUT(t -> {
        double c1 = 1.70158;
        double c3 = c1 + 1.0;
        return 1.0 + c3 * Math.pow(t - 1.0, 3.0) + c1 * Math.pow(t - 1.0, 2.0);
    }),
    BACK_IN_OUT(t -> {
        double c1 = 1.70158;
        double c2 = c1 * 1.525;
        return t < 0.5 ? Math.pow(2.0 * t, 2.0) * ((c2 + 1.0) * 2.0 * t - c2) / 2.0 : (Math.pow(2.0 * t - 2.0, 2.0) * ((c2 + 1.0) * (t * 2.0 - 2.0) + c2) + 2.0) / 2.0;
    }),
    CIRC_IN(t -> 1.0 - Math.sqrt(1.0 - Math.pow(t, 2.0))),
    CIRC_OUT(t -> Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0))),
    CIRC_IN_OUT(t -> t < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * t, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * t + 2.0, 2.0)) + 1.0) / 2.0),
    ELASTIC_IN(t -> {
        double c4 = 2.0943951023931953;
        return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * t - 10.0) * Math.sin((t * 10.0 - 10.75) * c4));
    }),
    ELASTIC_OUT(t -> {
        double c4 = 2.0943951023931953;
        return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * t) * Math.sin((t * 10.0 - 0.75) * c4) + 1.0);
    }),
    ELASTIC_IN_OUT(t -> {
        double c5 = 1.3962634015954636;
        return t == 0.0 ? 0.0 : (t == 1.0 ? 1.0 : (t < 0.5 ? -(Math.pow(2.0, 20.0 * t - 10.0) * Math.sin((20.0 * t - 11.125) * c5)) / 2.0 : Math.pow(2.0, -20.0 * t + 10.0) * Math.sin((20.0 * t - 11.125) * c5) / 2.0 + 1.0));
    }),
    SIN_IN(t -> 1.0 - Math.cos(t * Math.PI / 2.0)),
    SIN_OUT(t -> Math.sin(t * Math.PI / 2.0)),
    SIN_IN_OUT(t -> -0.5 * (Math.cos(Math.PI * t) - 1.0)),
    EXP_IN(t -> t == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * (t - 1.0))),
    EXP_OUT(t -> t == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * t)),
    EXP_IN_OUT(t -> {
        if (t == 0.0) {
            return 0.0;
        }
        if (t == 1.0) {
            return 1.0;
        }
        if (t < 0.5) {
            return 0.5 * Math.pow(2.0, 20.0 * t - 10.0);
        }
        return -0.5 * Math.pow(2.0, -20.0 * t + 10.0) + 1.0;
    }),
    COS_IN(t -> 1.0 - Math.cos(t * Math.PI / 2.0)),
    COS_OUT(t -> Math.sin(t * Math.PI / 2.0)),
    COS_IN_OUT(t -> -0.5 * (Math.cos(Math.PI * t) - 1.0)),
    BOUNCE_OUT(t -> {
        if (t < 0.36363636363636365) {
            return 121.0 * t * t / 16.0;
        }
        if (t < 0.7272727272727273) {
            return 9.075 * t * t - 9.9 * t + 3.4;
        }
        if (t < 0.9) {
            return 12.066481994459833 * t * t - 19.63545706371191 * t + 8.898060941828255;
        }
        return 10.8 * t * t - 20.52 * t + 10.72;
    }),
    BOUNCE_IN(t -> 1.0 - BOUNCE_OUT.ease(1.0 - t)),
    BOUNCE_IN_OUT(t -> t < 0.5 ? 0.5 * BOUNCE_IN.ease(t * 2.0) : 0.5 * BOUNCE_OUT.ease(t * 2.0 - 1.0) + 0.5),
    QUAD_IN(t -> t * t),
    QUAD_OUT(t -> -t.doubleValue() * (t - 2.0)),
    QUAD_IN_OUT(t -> t < 0.5 ? 2.0 * t * t : -2.0 * t * t + 4.0 * t - 1.0),
    QUART_IN(t -> t * t * t * t),
    QUART_OUT(t -> 1.0 - Math.pow(1.0 - t, 4.0)),
    QUART_IN_OUT(t -> t < 0.5 ? 8.0 * t * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 4.0) / 2.0),
    SINE_IN(t -> 1.0 - Math.cos(t * Math.PI / 2.0)),
    SINE_OUT(t -> Math.sin(t * Math.PI / 2.0)),
    SINE_IN_OUT(t -> -0.5 * (Math.cos(Math.PI * t) - 1.0)),
    CUBIC_IN(t -> t * t * t),
    CUBIC_OUT(t -> 1.0 - Math.pow(1.0 - t, 3.0)),
    CUBIC_IN_OUT(t -> t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0);

    private Function<Double, Double> function;

    private EasingType(Function<Double, Double> function) {
        this.function = function;
    }

    public double ease(double value) {
        return this.function.apply(Double.valueOf(MathUtils.clamp((float)value, -1.0f, 1.0f)));
    }
}

