/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;

public class AVector3f {
    public static final AVector3f ZERO = new AVector3f(0.0f, 0.0f, 0.0f);
    public static final AVector3f ONE = new AVector3f(1.0f, 1.0f, 1.0f);
    public float x;
    public float y;
    public float z;

    public AVector3f(float x, float y, float z) {
        this.x = MathUtils.floatSafe(x);
        this.y = MathUtils.floatSafe(y);
        this.z = MathUtils.floatSafe(z);
    }

    public AVector3f(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
    }

    public AVector3f(double x, double y, double z) {
        this.x = MathUtils.floatSafe((float)x);
        this.y = MathUtils.floatSafe((float)y);
        this.z = MathUtils.floatSafe((float)z);
    }

    public AVector3f(AVector3f vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public AVector3f add(AVector3f vector) {
        return new AVector3f(this.x + vector.getX(), this.y + vector.getY(), this.z + vector.getZ());
    }

    public AVector3f sub(AVector3f vector) {
        return new AVector3f(this.x - vector.getX(), this.y - vector.getY(), this.z - vector.getZ());
    }

    public AVector3f mul(AVector3f vector) {
        return new AVector3f(this.x * vector.getX(), this.y * vector.getY(), this.z * vector.getZ());
    }

    public AVector3f div(AVector3f vector) {
        return new AVector3f(this.x / vector.getX(), this.y / vector.getY(), this.z / vector.getZ());
    }

    public AVector3f add(float x1, float y1, float z1) {
        return new AVector3f(this.x + x1, this.y + y1, this.z + z1);
    }

    public AVector3f sub(float x1, float y1, float z1) {
        return new AVector3f(this.x - x1, this.y - y1, this.z - z1);
    }

    public AVector3f mul(float x1, float y1, float z1) {
        return new AVector3f(this.x * x1, this.y * y1, this.z * z1);
    }

    public AVector3f div(float x1, float y1, float z1) {
        return new AVector3f(this.x / x1, this.y / y1, this.z / z1);
    }

    public AVector3f add(float t) {
        return new AVector3f(this.x + t, this.y + t, this.z + t);
    }

    public AVector3f sub(float t) {
        return new AVector3f(this.x - t, this.y - t, this.z - t);
    }

    public AVector3f mul(float t) {
        return new AVector3f(this.x * t, this.y * t, this.z * t);
    }

    public AVector3f div(float t) {
        return new AVector3f(this.x / t, this.y / t, this.z / t);
    }

    public AVector3f clamp(AVector3f min, AVector3f max) {
        return new AVector3f(MathUtils.clamp(this.x, min.x, max.x), MathUtils.clamp(this.y, min.y, max.y), MathUtils.clamp(this.z, min.z, max.z));
    }

    public AVector3f interpolate(AVector3f vector, InterpolationType interpolationType, float t) {
        return new AVector3f(interpolationType.interpolate(this, vector, (double)t));
    }

    public AVector3f interpolateRot(AVector3f vector, InterpolationType interpolationType, float t) {
        return new AVector3f(interpolationType.interpolateRot(this, vector, (double)t));
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public AVector3f normalize() {
        float len2 = this.magnitude();
        if (len2 == 0.0f || len2 == 1.0f) {
            return new AVector3f(this.x, this.y, this.z);
        }
        return this.mul(1.0f / (float)Math.sqrt(len2));
    }

    public AVector3f direction(AVector3f vector) {
        return vector.sub(this).normalize();
    }

    public AVector3f directionWithoutNormalize(AVector3f vector) {
        return vector.sub(this);
    }

    public AVector3f rotateAroundAxis(AVector3f axis, double angle) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double x2 = axis.getX();
        double y2 = axis.getY();
        double z2 = axis.getZ();
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        double dotProduct = this.dot(axis);
        double xPrime = x2 * dotProduct * (1.0 - cosTheta) + x * cosTheta + (-z2 * y + y2 * z) * sinTheta;
        double yPrime = y2 * dotProduct * (1.0 - cosTheta) + y * cosTheta + (z2 * x - x2 * z) * sinTheta;
        double zPrime = z2 * dotProduct * (1.0 - cosTheta) + z * cosTheta + (-y2 * x + x2 * y) * sinTheta;
        return new AVector3f(xPrime, yPrime, zPrime);
    }

    public float angleTo(AVector3f vector3) {
        return MathUtils.atan2((float)this.cross(vector3).length(), this.dot(vector3));
    }

    public AVector3f rotateAroundX(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double y = angleCos * (double)this.getY() - angleSin * (double)this.getZ();
        double z = angleSin * (double)this.getY() + angleCos * (double)this.getZ();
        return new AVector3f((double)this.x, y, z);
    }

    public AVector3f rotateAroundY(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * (double)this.getX() + angleSin * (double)this.getZ();
        double z = -angleSin * (double)this.getX() + angleCos * (double)this.getZ();
        return new AVector3f(x, (double)this.y, z);
    }

    public AVector3f rotateAroundZ(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * (double)this.getX() - angleSin * (double)this.getY();
        double y = angleSin * (double)this.getX() + angleCos * (double)this.getY();
        return new AVector3f(x, y, (double)this.z);
    }

    public AVector3f rotation() {
        AVector3f dir = this.normalize();
        return new AVector3f(MathUtils.cos(dir.x), MathUtils.sin(dir.y), MathUtils.sin(dir.z));
    }

    public AVector3f rotationDegrees() {
        AVector3f dir = this.normalize();
        return new AVector3f(MathUtils.deg(MathUtils.cos(dir.x)), MathUtils.deg(MathUtils.sin(dir.y)), MathUtils.deg(MathUtils.sin(dir.z)));
    }

    public AVector2f yawPitch() {
        AVector3f dir = this.normalize();
        return new AVector2f(MathUtils.atan2(dir.x, dir.z), MathUtils.asin(dir.y));
    }

    public AVector2f yawPitchDeg() {
        AVector3f dir = this.normalize();
        return new AVector2f(MathUtils.deg(MathUtils.atan2(dir.x, dir.z)), MathUtils.deg(MathUtils.asin(dir.y)));
    }

    public static AVector3f fromYawPitch(float yaw, float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double sinPitch = Math.sin(pitchRadians);
        double cosPitch = Math.cos(pitchRadians);
        double sinYaw = Math.sin(yawRadians);
        double cosYaw = Math.cos(yawRadians);
        return new AVector3f(-cosPitch * sinYaw, sinPitch, -cosPitch * cosYaw);
    }

    public float distanceTo(AVector3f vector) {
        return MathUtils.sqrt(this.distanceToSquared(vector));
    }

    public float distanceToSquared(AVector3f vector) {
        float resX = (this.x - vector.x) * (this.x - vector.x);
        float resY = (this.y - vector.y) * (this.y - vector.y);
        float resZ = (this.z - vector.z) * (this.z - vector.z);
        return resX + resY + resZ;
    }

    public float distanceToX(AVector3f vector) {
        float res = (this.x - vector.x) * (this.x - vector.x);
        return MathUtils.sqrt(res);
    }

    public float distanceToY(AVector3f vector) {
        float res = (this.y - vector.y) * (this.y - vector.y);
        return MathUtils.sqrt(res);
    }

    public float distanceToZ(AVector3f vector) {
        float res = (this.z - vector.z) * (this.z - vector.z);
        return MathUtils.sqrt(res);
    }

    public float distanceToXSquared(AVector3f vector) {
        float res = (this.x - vector.x) * (this.x - vector.x);
        return res;
    }

    public float distanceToYSquared(AVector3f vector) {
        float res = (this.y - vector.y) * (this.y - vector.y);
        return res;
    }

    public float distanceToZSquared(AVector3f vector) {
        float res = (this.z - vector.z) * (this.z - vector.z);
        return res;
    }

    public float dot(AVector3f vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public AVector3f cross(AVector3f vector) {
        return new AVector3f(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public Vector3d toVector3d() {
        return new Vector3d((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3f toVector3f() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public Vec3 toVec3() {
        return new Vec3((double)this.x, (double)this.y, (double)this.z);
    }

    public Vec3i toVec3i() {
        return new Vec3i((int)this.x, (int)this.y, (int)this.z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos((int)this.x, (int)this.y, (int)this.z);
    }

    public AVector2f xy() {
        return new AVector2f(this.x, this.y);
    }

    public AVector2f zy() {
        return new AVector2f(this.z, this.y);
    }

    public AVector2f xz() {
        return new AVector2f(this.x, this.z);
    }

    public AVector3f wrapDegrees() {
        return new AVector3f(MathUtils.wrapDegrees(this.x), MathUtils.wrapDegrees(this.y), MathUtils.wrapDegrees(this.z));
    }

    public AVector3f wrapRadians() {
        return new AVector3f(MathUtils.wrapRadians(this.x), MathUtils.wrapRadians(this.y), MathUtils.wrapRadians(this.z));
    }

    public boolean equalsApprox(AVector3f vector, float t) {
        return MathUtils.equalsApprox(this.x, vector.x, t) && MathUtils.equalsApprox(this.y, vector.y, t) && MathUtils.equalsApprox(this.z, vector.z, t);
    }

    public AVector3f transform(Quaternionf quaternion) {
        Vector3f vector3f = this.toVector3f();
        vector3f = quaternion.transform(vector3f);
        return AVector3f.from(vector3f);
    }

    public AVector3f transform(Matrix3f matrix) {
        Vector3f vector3f = this.toVector3f();
        vector3f = matrix.transform(vector3f);
        return AVector3f.from(vector3f);
    }

    public AVector3f rad() {
        return new AVector3f(MathUtils.rad(this.x), MathUtils.rad(this.y), MathUtils.rad(this.z));
    }

    public AVector3f deg() {
        return new AVector3f(MathUtils.deg(this.x), MathUtils.deg(this.y), MathUtils.deg(this.z));
    }

    public static AVector3f from(float x, float y, float z) {
        return new AVector3f(x, y, z);
    }

    public static AVector3f from(BlockPos pos) {
        return new AVector3f(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static AVector3f from(Vector3d vector) {
        return AVector3f.from((float)vector.x, (float)vector.y, (float)vector.z);
    }

    public static AVector3f from(Vector3f vector) {
        return new AVector3f(vector.x(), vector.y(), vector.z());
    }

    public static AVector3f from(Vec3 vector) {
        return AVector3f.from((float)vector.f_82479_, (float)vector.f_82480_, (float)vector.f_82481_);
    }

    public static AVector3f rad(float x, float y, float z) {
        return new AVector3f(MathUtils.rad(x), MathUtils.rad(y), MathUtils.rad(z));
    }

    public AVector3f copy() {
        return new AVector3f(this.x, this.y, this.z);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("x", this.x);
        tag.m_128350_("y", this.y);
        tag.m_128350_("z", this.z);
        return tag;
    }

    public static AVector3f fromNbt(CompoundTag tag) {
        return new AVector3f(tag.m_128457_("x"), tag.m_128457_("y"), tag.m_128457_("z"));
    }

    public float[] toFloatArray(AVector3f vector3) {
        return new float[]{vector3.x, vector3.y, vector3.z};
    }

    public static AVector3f fromFloatArray(float[] array) {
        return new AVector3f(array[0], array[1], array[2]);
    }

    public static AVector3f zero() {
        return new AVector3f(0.0f, 0.0f, 0.0f);
    }

    public static AVector3f one() {
        return new AVector3f(1.0f, 1.0f, 1.0f);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public String toString() {
        return "[x=" + this.x + ";y=" + this.y + ";z=" + this.z + "]";
    }
}

