/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.entity.MobFlyingBird;
import ru.astemir.astemirlib.common.handler.EventEntity;
import ru.astemir.astemirlib.common.math.AVector3f;

public class GoalRandomFly<T extends PathfinderMob & EventEntity>
extends Goal {
    protected final T bird;
    private AVector3f position = new AVector3f(0.0f, 0.0f, 0.0f);
    private boolean flightTarget = false;
    private int orbitResetCooldown = 0;
    private int maxOrbitTime = 360;
    private int orbitTime = 0;

    public GoalRandomFly(T mob) {
        this.bird = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public void resetCooldown() {
        if (this.orbitResetCooldown < 0) {
            ++this.orbitResetCooldown;
        }
    }

    public boolean generatePosition() {
        if (this.bird.m_6162_()) {
            this.flightTarget = false;
        } else if (this.bird.m_20072_()) {
            this.flightTarget = true;
        } else if (this.bird.m_20096_()) {
            this.flightTarget = this.bird.m_217043_().m_188503_(10) == 0;
        } else {
            if (this.orbitResetCooldown == 0 && this.bird.m_217043_().m_188503_(6) == 0) {
                this.orbitResetCooldown = 100 + this.bird.m_217043_().m_188503_(300);
                ((MobFlyingBird)this.bird).setOrbitPos(this.bird.m_20183_());
                ((MobFlyingBird)this.bird).setOrbitDistance(10 + this.bird.m_217043_().m_188503_(10));
                ((MobFlyingBird)this.bird).setOrbitClockwise(this.bird.m_217043_().m_188499_());
                this.orbitTime = 0;
                this.maxOrbitTime = (int)(180.0f + 360.0f * this.bird.m_217043_().m_188501_());
            }
            this.flightTarget = this.bird.m_217043_().m_188503_(5) != 0 && ((MobFlyingBird)this.bird).getTimeFlying() < 400;
        }
        Vec3 newPosition = this.getRandomPos();
        if (newPosition == null) {
            return false;
        }
        this.position = AVector3f.from(newPosition);
        return true;
    }

    public boolean m_8036_() {
        if (this.bird.m_5448_() != null && this.bird.m_5448_().m_6084_() && !this.bird.m_20160_() || this.bird.m_20159_()) {
            return false;
        }
        if (this.bird.m_217043_().m_188503_(10) != 0 && !((MobFlyingBird)this.bird).isFlying()) {
            return false;
        }
        return this.generatePosition();
    }

    public void m_8037_() {
        if (this.orbitResetCooldown > 0) {
            --this.orbitResetCooldown;
        }
        if (this.orbitResetCooldown < 0) {
            ++this.orbitResetCooldown;
        }
        if (this.orbitResetCooldown > 0 && ((MobFlyingBird)this.bird).getOrbitPos() != null) {
            if (this.orbitTime < this.maxOrbitTime && !this.bird.m_20072_()) {
                ++this.orbitTime;
            } else {
                this.orbitTime = 0;
                ((MobFlyingBird)this.bird).setOrbitPos(null);
                this.orbitResetCooldown = -((MobFlyingBird)this.bird).getOrbitCooldown() - this.bird.m_217043_().m_188503_(((MobFlyingBird)this.bird).getOrbitCooldown());
            }
        }
        if (((PathfinderMob)this.bird).f_19862_ && !this.bird.m_20096_()) {
            this.m_8041_();
        }
        if (this.flightTarget) {
            this.bird.m_21566_().m_6849_((double)this.position.x, (double)this.position.y, (double)this.position.z, 2.0);
        } else if (!((MobFlyingBird)this.bird).isFlying() || this.bird.m_20096_()) {
            this.bird.m_21573_().m_26519_((double)this.position.x, (double)this.position.y, (double)this.position.z, 1.0);
        }
        if (!this.flightTarget && ((MobFlyingBird)this.bird).isFlying()) {
            ((MobFlyingBird)this.bird).setFallFlag(true);
            if (this.bird.m_20096_()) {
                ((MobFlyingBird)this.bird).setFlying(false);
                ((MobFlyingBird)this.bird).setOrbitPos(null);
                this.orbitTime = 0;
                this.orbitResetCooldown = -((MobFlyingBird)this.bird).getOrbitCooldown() - this.bird.m_217043_().m_188503_(((MobFlyingBird)this.bird).getOrbitCooldown());
            }
        }
        if (((MobFlyingBird)this.bird).isFlying() && (!this.bird.m_9236_().m_46859_(new BlockPos((int)this.bird.m_20182_().f_82479_, (int)(this.bird.m_20191_().f_82289_ - 0.5000001), (int)this.bird.m_20182_().f_82481_)) || this.bird.m_20096_()) && !this.bird.m_20072_() && ((MobFlyingBird)this.bird).getTimeFlying() > 30) {
            ((MobFlyingBird)this.bird).setFlying(false);
            ((MobFlyingBird)this.bird).setOrbitPos(null);
            this.orbitTime = 0;
            this.orbitResetCooldown = -((MobFlyingBird)this.bird).getOrbitCooldown() - this.bird.m_217043_().m_188503_(((MobFlyingBird)this.bird).getOrbitCooldown());
        }
    }

    private Vec3 getOrbitVec(Vec3 vector3d, float gatheringCircleDist) {
        float angle = (float)Math.PI / 180 * (float)((MobFlyingBird)this.bird).getOrbitDistance() * (float)(((MobFlyingBird)this.bird).isOrbitClockwise() ? -((PathfinderMob)this.bird).f_19797_ : ((PathfinderMob)this.bird).f_19797_);
        double extraX = gatheringCircleDist * Mth.m_14031_((float)angle);
        double extraZ = gatheringCircleDist * Mth.m_14089_((float)angle);
        if (((MobFlyingBird)this.bird).getOrbitPos() != null) {
            Vec3 pos = new Vec3((double)((MobFlyingBird)this.bird).getOrbitPos().m_123341_() + extraX, (double)(((MobFlyingBird)this.bird).getOrbitPos().m_123342_() + this.bird.m_217043_().m_188503_(2)), (double)((MobFlyingBird)this.bird).getOrbitPos().m_123343_() + extraZ);
            if (this.bird.m_9236_().m_46859_(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_))) {
                return pos;
            }
        }
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.bird.m_20183_();
        while (position.m_123342_() > -64 && this.bird.m_9236_().m_46859_(position)) {
            position = position.m_7495_();
        }
        return !this.bird.m_9236_().m_6425_(position).m_76178_() || position.m_123342_() <= -64;
    }

    public Vec3 getBlockInViewAway(Vec3 fleePos, float radiusAdd) {
        float radius = 5.0f + radiusAdd + (float)this.bird.m_217043_().m_188503_(5);
        float neg = this.bird.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = ((PathfinderMob)this.bird).f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.bird.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.m_7096_() + extraX), 0, (int)(fleePos.m_7094_() + extraZ));
        BlockPos ground = this.getGround(radialPos);
        int distFromGround = (int)this.bird.m_20186_() - ground.m_123342_();
        int flightHeight = ((MobFlyingBird)this.bird).getFlightHeight();
        BlockPos newPos = ground.m_6630_(distFromGround > 3 ? flightHeight : this.bird.m_217043_().m_188503_(4) + 8);
        if (!this.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos)) && this.bird.m_20238_(Vec3.m_82512_((Vec3i)newPos)) > 1.0) {
            return Vec3.m_82512_((Vec3i)newPos);
        }
        return null;
    }

    public BlockPos getGround(BlockPos in) {
        BlockPos position = new BlockPos(in.m_123341_(), (int)this.bird.m_20186_(), in.m_123343_());
        while (position.m_123342_() < 320 && !this.bird.m_9236_().m_6425_(position).m_76178_()) {
            position = position.m_7494_();
        }
        while (position.m_123342_() > -64 && !this.bird.m_9236_().m_8055_(position).m_60804_((BlockGetter)this.bird.m_9236_(), position) && this.bird.m_9236_().m_6425_(position).m_76178_()) {
            position = position.m_7495_();
        }
        return position;
    }

    public Vec3 getBlockGrounding(Vec3 fleePos) {
        float radius = 10 + this.bird.m_217043_().m_188503_(15);
        float neg = this.bird.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = ((PathfinderMob)this.bird).f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.bird.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)Math.PI + angle));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = new BlockPos((int)(fleePos.m_7096_() + extraX), (int)this.bird.m_20186_(), (int)(fleePos.m_7094_() + extraZ));
        BlockPos ground = this.getGround(radialPos);
        if (ground.m_123342_() == 0) {
            return this.bird.m_20182_();
        }
        ground = this.bird.m_20183_();
        while (ground.m_123342_() > -62 && !this.bird.m_9236_().m_8055_(ground).m_60804_((BlockGetter)this.bird.m_9236_(), ground)) {
            ground = ground.m_7495_();
        }
        if (!this.isTargetBlocked(Vec3.m_82512_((Vec3i)ground.m_7494_()))) {
            return Vec3.m_82512_((Vec3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 vec3 = new Vec3(this.bird.m_20185_(), this.bird.m_20188_(), this.bird.m_20189_());
        return this.bird.m_9236_().m_45547_(new ClipContext(vec3, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.bird)).m_6662_() != HitResult.Type.MISS;
    }

    protected Vec3 getRandomPos() {
        Vec3 vector3d = this.bird.m_20182_();
        if (this.orbitResetCooldown > 0 && ((MobFlyingBird)this.bird).getOrbitPos() != null) {
            return this.getOrbitVec(vector3d, 5 + this.bird.m_217043_().m_188503_(10));
        }
        if (this.bird.m_20160_() || this.isOverWaterOrVoid()) {
            this.flightTarget = true;
        }
        if (this.flightTarget) {
            if (((MobFlyingBird)this.bird).getTimeFlying() < 340 || this.bird.m_20160_() || this.isOverWaterOrVoid()) {
                return this.getBlockInViewAway(vector3d, 5.0f);
            }
            return this.getBlockGrounding(vector3d);
        }
        return LandRandomPos.m_148488_(this.bird, (int)10, (int)30);
    }

    public boolean m_8045_() {
        if (this.flightTarget) {
            return ((MobFlyingBird)this.bird).isFlying() && this.bird.m_20275_((double)this.position.x, (double)this.position.y, (double)this.position.z) > 20.0;
        }
        return !this.bird.m_21573_().m_26571_() && !this.bird.m_20160_();
    }

    public void m_8056_() {
        if (this.flightTarget) {
            ((MobFlyingBird)this.bird).setFlying(true);
            this.bird.m_21566_().m_6849_((double)this.position.x, (double)this.position.y, (double)this.position.z, 2.0);
        } else {
            this.bird.m_21573_().m_26519_((double)this.position.x, (double)this.position.y, (double)this.position.z, 1.0);
        }
    }

    public void m_8041_() {
        this.bird.m_21573_().m_26573_();
        super.m_8041_();
    }

    public AVector3f getPosition() {
        return this.position;
    }

    public void setPosition(AVector3f position) {
        this.position = position;
    }

    public boolean isFlightTarget() {
        return this.flightTarget;
    }

    public void setFlightTarget(boolean flightTarget) {
        this.flightTarget = flightTarget;
    }

    public int getOrbitResetCooldown() {
        return this.orbitResetCooldown;
    }

    public void setOrbitResetCooldown(int orbitResetCooldown) {
        this.orbitResetCooldown = orbitResetCooldown;
    }

    public int getMaxOrbitTime() {
        return this.maxOrbitTime;
    }

    public void setMaxOrbitTime(int maxOrbitTime) {
        this.maxOrbitTime = maxOrbitTime;
    }

    public int getOrbitTime() {
        return this.orbitTime;
    }

    public void setOrbitTime(int orbitTime) {
        this.orbitTime = orbitTime;
    }
}

