/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.command.build;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.command.build.CommandPart;

public class CommandArgument
extends CommandPart {
    private ArgumentType type;
    private SuggestionProvider suggestionProvider;

    public CommandArgument(String name, ArgumentType type) {
        super(name);
        this.type = type;
    }

    public static CommandArgument blockPos(String name) {
        return new CommandArgument(name, (ArgumentType)BlockPosArgument.m_118239_());
    }

    public static CommandArgument word(String name) {
        return new CommandArgument(name, (ArgumentType)StringArgumentType.word());
    }

    public static CommandArgument string(String name) {
        return new CommandArgument(name, (ArgumentType)StringArgumentType.string());
    }

    public static CommandArgument greedyString(String name) {
        return new CommandArgument(name, (ArgumentType)StringArgumentType.greedyString());
    }

    public static CommandArgument integer(String name) {
        return new CommandArgument(name, (ArgumentType)IntegerArgumentType.integer());
    }

    public static CommandArgument bool(String name) {
        return new CommandArgument(name, (ArgumentType)BoolArgumentType.bool());
    }

    public static CommandArgument doubleArg(String name) {
        return new CommandArgument(name, (ArgumentType)DoubleArgumentType.doubleArg());
    }

    public static CommandArgument integer(String name, int min, int max) {
        return new CommandArgument(name, (ArgumentType)IntegerArgumentType.integer((int)min, (int)max));
    }

    public static CommandArgument integer(String name, int min) {
        return new CommandArgument(name, (ArgumentType)IntegerArgumentType.integer((int)min));
    }

    public static CommandArgument entities(String name) {
        return new CommandArgument(name, (ArgumentType)EntityArgument.m_91460_());
    }

    public static CommandArgument create(String name, ArgumentType type) {
        return new CommandArgument(name, type);
    }

    public static CommandArgument players(String name) {
        return new CommandArgument(name, (ArgumentType)EntityArgument.m_91470_());
    }

    public static CommandArgument vector3(String name) {
        return new CommandArgument(name, (ArgumentType)Vec3Argument.m_120847_((boolean)false));
    }

    public static CommandArgument vector2(String name) {
        return new CommandArgument(name, (ArgumentType)Vec2Argument.m_174954_((boolean)false));
    }

    public CommandArgument suggestion(SuggestionProvider suggestionProvider) {
        this.suggestionProvider = suggestionProvider;
        return this;
    }

    public int getInt(CommandContext<CommandSourceStack> context) {
        return IntegerArgumentType.getInteger(context, (String)this.getArgumentName());
    }

    public boolean getBoolean(CommandContext<CommandSourceStack> context) {
        return BoolArgumentType.getBool(context, (String)this.getArgumentName());
    }

    public double getDouble(CommandContext<CommandSourceStack> context) {
        return DoubleArgumentType.getDouble(context, (String)this.getArgumentName());
    }

    public String getString(CommandContext<CommandSourceStack> context) {
        return StringArgumentType.getString(context, (String)this.getArgumentName());
    }

    public Vec3 getVector3(CommandContext<CommandSourceStack> context) {
        return Vec3Argument.m_120844_(context, (String)this.getArgumentName());
    }

    public BlockPos getBlockPos(CommandContext<CommandSourceStack> context) {
        try {
            return BlockPosArgument.m_118242_(context, (String)this.getArgumentName());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> context) {
        try {
            return EntityArgument.m_91461_(context, (String)this.getArgumentName());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    @Override
    public ArgumentBuilder build() {
        RequiredArgumentBuilder res = Commands.m_82129_((String)this.getArgumentName(), (ArgumentType)this.type);
        if (this.suggestionProvider != null) {
            res = res.suggests(this.suggestionProvider);
        }
        return res;
    }
}

