/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.action;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ru.astemir.astemirlib.common.action.ActionListener;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.action.HolderKey;
import ru.astemir.astemirlib.common.network.NetworkUtils;
import ru.astemir.astemirlib.common.network.messages.ClientMessageActionController;

public class ActionController<T extends ActionListener> {
    public static final ActionState NO_ACTION = new ActionState(-1, "noAction", -1);
    private ActionState[] actions;
    private ActionState currentAction = NO_ACTION;
    private T owner;
    private String name;
    private int actionTick = 0;

    public static <T extends ActionListener> ActionController create(T owner, String name, ActionState ... actions) {
        return new ActionController<T>(owner, name, actions);
    }

    public ActionController(T owner, String name, ActionState ... actions) {
        this(owner, name, 0, actions);
    }

    public ActionController(T owner, String name, int delay, ActionState ... actions) {
        this.owner = owner;
        this.name = name;
        this.actions = actions;
    }

    public void playAction(String actionName) {
        this.playAction(actionName, 0);
    }

    public void playAction(String actionName, int ownDelay) {
        ActionState action = this.getActionByName(actionName);
        if (action != null) {
            this.playAction(action, ownDelay);
        }
    }

    public void playAction(ActionState action) {
        this.playAction(action, 0);
    }

    public void playAction(ActionState action, int delay) {
        if (!(this.getLevel().f_46443_ || this.is(action) && !action.isCanOverrideSelf())) {
            if (action.getLength() > 0) {
                this.setActionWithoutSync(action, action.getLength() + delay);
            } else {
                this.setActionWithoutSync(action, -1);
            }
            this.sendUpdatePacket();
            action.onStart(this);
            action.getLinks().start(this);
            this.getOwner().onActionBegin(action);
            this.onActionBegin(action);
        }
    }

    @Deprecated
    public void setActionWithTime(ActionState action, int delay) {
        if (!(this.getLevel().f_46443_ || this.is(action) && !action.isCanOverrideSelf())) {
            this.setActionWithoutSync(action, delay);
            this.sendUpdatePacket();
            action.onStart(this);
            action.getLinks().start(this);
            this.getOwner().onActionBegin(action);
            this.onActionBegin(action);
        }
    }

    @Deprecated
    public void setAction(ActionState action, int ticks) {
        if (!(this.getLevel().f_46443_ || this.is(this.currentAction) && !this.currentAction.isCanOverrideSelf())) {
            if (ticks > 0) {
                this.setActionWithoutSync(action, ticks);
            } else {
                this.setActionWithoutSync(action, -1);
            }
            this.sendUpdatePacket();
            action.onStart(this);
            action.getLinks().start(this);
            this.getOwner().onActionBegin(action);
            this.onActionBegin(action);
        }
    }

    public void setActionWithoutSync(ActionState action, int ticks) {
        this.currentAction = action;
        this.actionTick = ticks;
    }

    public String getName() {
        return this.name;
    }

    public int getTicks() {
        return this.actionTick;
    }

    public void setTick(int ticks) {
        this.actionTick = ticks;
    }

    public void setNoState() {
        this.playAction(NO_ACTION);
    }

    public boolean isNoAction() {
        return this.getActionState() == NO_ACTION;
    }

    public boolean is(ActionState state) {
        return this.getActionState() == state;
    }

    public boolean is(ActionState ... states) {
        for (ActionState state : states) {
            if (!this.is(state)) continue;
            return true;
        }
        return false;
    }

    public boolean isActionAt(ActionState action, int time) {
        int ticks;
        return this.is(action) && (ticks = this.getActionState().getLength() - this.getTicks()) == time;
    }

    public boolean isActionAt(ActionState action, double time) {
        int ticks;
        return this.is(action) && (double)((float)(ticks = this.getActionState().getLength() - this.getTicks()) / 20.0f) == time;
    }

    public void update() {
        if (!this.getLevel().f_46443_) {
            ActionState previous = this.currentAction;
            if (!this.isNoAction()) {
                if (this.actionTick > 0) {
                    this.currentAction.onTick(this, this.actionTick);
                    this.currentAction.getLinks().tick(this, this.actionTick);
                    this.onActionTick(this.currentAction, this.actionTick);
                    this.getOwner().onActionTick(this.currentAction, this.actionTick);
                    this.sendUpdatePacket();
                    --this.actionTick;
                } else if (this.actionTick != -1) {
                    this.currentAction.onEnd(this);
                    this.currentAction.getLinks().end(this);
                    this.onActionEnd(this.currentAction);
                    this.getOwner().onActionEnd(this.currentAction);
                    if (this.is(previous) && this.actionTick != -1) {
                        this.playAction(NO_ACTION);
                    }
                } else if (this.actionTick == -1) {
                    this.sendUpdatePacket();
                }
            }
        }
    }

    public Level getLevel() {
        if (this.owner instanceof Entity) {
            return ((Entity)this.owner).m_9236_();
        }
        if (this.owner instanceof BlockEntity) {
            return ((BlockEntity)this.owner).m_58904_();
        }
        return null;
    }

    public void sendUpdatePacket() {
        if (this.owner instanceof Entity) {
            Entity entity = (Entity)this.owner;
            NetworkUtils.sendToAllPlayers(new ClientMessageActionController(new HolderKey(entity.m_19879_()), this.owner.getActionStateMachine().getIdByName(this.getName()), this.currentAction.getId(), this.actionTick));
        }
        if (this.owner instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)this.owner;
            BlockPos pos = blockEntity.m_58899_();
            NetworkUtils.sendToAllPlayers(new ClientMessageActionController(new HolderKey(pos), this.owner.getActionStateMachine().getIdByName(this.getName()), this.currentAction.getId(), this.actionTick));
        }
    }

    public void sendUpdatePacket(ServerPlayer player) {
        if (this.owner instanceof Entity) {
            Entity entity = (Entity)this.owner;
            NetworkUtils.sendToPlayer(player, new ClientMessageActionController(new HolderKey(entity.m_19879_()), this.owner.getActionStateMachine().getIdByName(this.getName()), this.currentAction.getId(), this.actionTick));
        }
        if (this.owner instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)this.owner;
            BlockPos pos = blockEntity.m_58899_();
            NetworkUtils.sendToPlayer(player, new ClientMessageActionController(new HolderKey(pos), this.owner.getActionStateMachine().getIdByName(this.getName()), this.currentAction.getId(), this.actionTick));
        }
    }

    public ActionState[] getActions() {
        return this.actions;
    }

    public ActionState getActionByName(String name) {
        for (ActionState action : this.actions) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        return NO_ACTION;
    }

    public ActionState getActionById(int id) {
        if (id == -1) {
            return NO_ACTION;
        }
        for (ActionState action : this.actions) {
            if (action.getId() != id) continue;
            return action;
        }
        return NO_ACTION;
    }

    public T getOwner() {
        return this.owner;
    }

    public ActionState getActionState() {
        return this.currentAction;
    }

    public void onActionBegin(ActionState state) {
    }

    public void onActionEnd(ActionState state) {
    }

    public void onActionTick(ActionState state, int ticks) {
    }
}

