/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.renderer;

import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EntityRenderData {
    public float walkingSpeed = 0.0f;
    public float walkingPosition = 0.0f;
    public float bodyRotation = 0.0f;
    public float headYaw = 0.0f;
    public float entityYaw = 0.0f;
    public float entityPitch = 0.0f;
    public float ageInTicks = 0.0f;
    public float partialTick = 0.0f;
    public boolean shouldSit = false;

    public static <T extends Entity> EntityRenderData prepare(T entity, float partialTick) {
        Entity entity2;
        LivingEntity livingEntity;
        EntityRenderData renderData = new EntityRenderData();
        renderData.partialTick = partialTick;
        renderData.shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        renderData.walkingSpeed = 0.0f;
        renderData.walkingPosition = 0.0f;
        renderData.bodyRotation = 0.0f;
        renderData.headYaw = 0.0f;
        renderData.entityYaw = 0.0f;
        renderData.entityPitch = Mth.m_14189_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
        renderData.ageInTicks = (float)entity.f_19797_ + renderData.partialTick;
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            renderData.bodyRotation = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
            renderData.headYaw = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
            renderData.entityYaw = renderData.headYaw - renderData.bodyRotation;
        } else {
            renderData.entityYaw = Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
        }
        if (renderData.shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            renderData.bodyRotation = Mth.m_14189_((float)partialTick, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
            renderData.entityYaw = Mth.m_14177_((float)(renderData.headYaw - renderData.bodyRotation));
            float wrappedRotationDifference = Mth.m_14177_((float)renderData.entityYaw);
            if (wrappedRotationDifference < -85.0f) {
                wrappedRotationDifference = -85.0f;
            }
            if (wrappedRotationDifference >= 85.0f) {
                wrappedRotationDifference = 85.0f;
            }
            renderData.bodyRotation = renderData.headYaw - wrappedRotationDifference;
            if (wrappedRotationDifference * wrappedRotationDifference > 2500.0f) {
                renderData.bodyRotation += wrappedRotationDifference * 0.2f;
            }
            renderData.entityYaw = Mth.m_14177_((float)(renderData.headYaw - renderData.bodyRotation));
        }
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            if (LivingEntityRenderer.m_194453_((LivingEntity)livingEntity)) {
                renderData.entityPitch *= -1.0f;
                renderData.entityYaw *= -1.0f;
            }
            if (!renderData.shouldSit && entity.m_6084_()) {
                renderData.walkingSpeed = livingEntity.f_267362_.m_267711_(partialTick);
                renderData.walkingPosition = livingEntity.f_267362_.m_267590_(partialTick);
                if (livingEntity.m_6162_()) {
                    renderData.walkingPosition *= 3.0f;
                }
                if (renderData.walkingSpeed > 1.0f) {
                    renderData.walkingSpeed = 1.0f;
                }
            }
        }
        return renderData;
    }
}

