/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import ru.astemir.astemirlib.client.bedrock.model.BedrockEntityModel;
import ru.astemir.astemirlib.common.math.Color;

public interface BaseEntityRenderer<T extends Entity, K extends BedrockEntityModel<T>> {
    public K getModel(T var1);

    default public void setupScale(T entity, BedrockEntityModel<T> model, PoseStack poseStack, float partialTick) {
    }

    default public void setupRotation(T entity, BedrockEntityModel<T> model, PoseStack poseStack, float bodyRotation, float partialTick) {
    }

    default public float getRotationFromDir(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    default public Color getColor(T entity) {
        return Color.WHITE;
    }
}

