/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import ru.astemir.astemirlib.client.RenderUtils;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockCubeRender;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;

public class BedrockModelPart
extends ModelPart {
    private final Map<String, BedrockModelPart> children;
    private final List<BedrockCubeRender> cubes;
    private AVector3f scale = new AVector3f(1.0f, 1.0f, 1.0f);
    private AVector3f offset = new AVector3f(0.0f, 0.0f, 0.0f);
    private AVector3f rotation;
    public AVector3f defaultRotation;
    public AVector3f customRotation = new AVector3f(0.0f, 0.0f, 0.0f);
    public AVector3f customScale = new AVector3f(1.0f, 1.0f, 1.0f);
    public AVector3f customOffset = new AVector3f(0.0f, 0.0f, 0.0f);
    private PoseStack.Pose lastPose;
    public BedrockModelPart parent;

    public BedrockModelPart(AVector3f defaultRotation, @NotNull List<BedrockCubeRender> cubes, Map<String, BedrockModelPart> children, boolean neverRender) {
        super(Collections.emptyList(), Collections.emptyMap());
        this.defaultRotation = defaultRotation;
        this.rotation = new AVector3f(defaultRotation);
        this.f_104207_ = !neverRender;
        this.children = children;
        this.cubes = cubes;
        this.children.forEach((name, part) -> {
            part.parent = this;
        });
    }

    @Deprecated
    public void m_104306_(PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_104207_) {
            poseStack.m_85836_();
            this.m_104299_(poseStack);
            this.m_104290_(this.lastPose, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            for (BedrockModelPart part : this.children.values()) {
                part.m_104306_(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }
    }

    public <T extends Animated> void renderFinal(BedrockModel bedrockModel, T object, PoseStack poseStack, VertexConsumer vertexConsumer, MultiBufferSource bufferSource, int packedLightIn, int packedOverlayIn, Color color) {
        if (this.f_104207_) {
            PoseStack copyPoseStack = RenderUtils.copyPoseStack(poseStack);
            this.m_104299_(copyPoseStack);
            this.lastPose = copyPoseStack.m_85850_();
            poseStack.m_85836_();
            this.m_104299_(poseStack);
            PoseStack.Pose pose = poseStack.m_85850_();
            this.m_104290_(pose, vertexConsumer, packedLightIn, packedOverlayIn, color.r, color.g, color.b, color.a);
            for (BedrockModelPart part : this.children.values()) {
                part.renderFinal(bedrockModel, object, poseStack, vertexConsumer, bufferSource, packedLightIn, packedOverlayIn, color);
            }
            poseStack.m_85849_();
        }
    }

    public void m_104299_(PoseStack matrixStackIn) {
        this.applyPivot(matrixStackIn);
        this.applyOffset(matrixStackIn);
        this.applyRotation(matrixStackIn);
        this.applyScale(matrixStackIn);
    }

    public void applyPivot(PoseStack matrixStackIn) {
        matrixStackIn.m_252880_(this.f_104200_ / 16.0f, this.f_104201_ / 16.0f, this.f_104202_ / 16.0f);
    }

    public void applyOffset(PoseStack matrixStackIn) {
        matrixStackIn.m_252880_(this.offset.x / 16.0f, this.offset.y / 16.0f, this.offset.z / 16.0f);
        matrixStackIn.m_252880_(this.customOffset.x / 16.0f, this.customOffset.y / 16.0f, this.customOffset.z / 16.0f);
    }

    public void applyRotation(PoseStack matrixStackIn) {
        AVector3f rotation = this.getRotation().sub(this.getCustomRotation());
        if (rotation.x != 0.0f || rotation.y != 0.0f || rotation.z != 0.0f) {
            matrixStackIn.m_252781_(new Quaternionf().rotateZYX(rotation.z, rotation.y, rotation.x));
        }
    }

    public void applyScale(PoseStack matrixStackIn) {
        if (this.scale.x * this.customScale.x != 1.0f || this.scale.y * this.customScale.y != 1.0f || this.scale.z * this.customScale.z != 1.0f) {
            matrixStackIn.m_85841_(this.scale.x * this.customScale.x, this.scale.y * this.customScale.y, this.scale.z * this.customScale.z);
        }
    }

    private void m_104290_(PoseStack.Pose pose, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        for (BedrockCubeRender cube : this.cubes) {
            cube.compile(pose, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }

    public BedrockModelPart getChild(String name) {
        for (Map.Entry<String, BedrockModelPart> entry : this.children.entrySet()) {
            if (entry.getKey().equals(name)) {
                return entry.getValue();
            }
            BedrockModelPart childPart = entry.getValue().getChild(name);
            if (childPart == null) continue;
            return childPart;
        }
        return null;
    }

    public String getChildName(BedrockModelPart part) {
        for (Map.Entry<String, BedrockModelPart> entry : this.children.entrySet()) {
            if (entry.getValue() == part) {
                return entry.getKey();
            }
            String name = entry.getValue().getChildName(part);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public void setAllVisible() {
        for (Map.Entry<String, BedrockModelPart> entry : this.getChildren().entrySet()) {
            entry.getValue().f_233556_ = false;
            entry.getValue().setAllVisible();
        }
    }

    public void resetAll() {
        for (Map.Entry<String, BedrockModelPart> entry : this.getChildren().entrySet()) {
            BedrockModelPart modelPart = entry.getValue();
            modelPart.reset();
            modelPart.resetAll();
        }
    }

    public void reset() {
        this.rotation = new AVector3f(this.defaultRotation.x, this.defaultRotation.y, this.defaultRotation.z);
        this.offset = new AVector3f(0.0f, 0.0f, 0.0f);
        this.scale = new AVector3f(1.0f, 1.0f, 1.0f);
        this.customRotation = new AVector3f(0.0f, 0.0f, 0.0f);
        this.customOffset = new AVector3f(0.0f, 0.0f, 0.0f);
        this.customScale = new AVector3f(1.0f, 1.0f, 1.0f);
    }

    public Map<String, BedrockModelPart> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public void setRotation(AVector3f vector3) {
        this.rotation = new AVector3f(vector3.x, vector3.y, vector3.z);
    }

    public void m_171327_(float x, float y, float z) {
        this.setRotation(new AVector3f(x, y, z));
    }

    public void setOffset(AVector3f vector3) {
        this.offset = new AVector3f(vector3.x, vector3.y, vector3.z);
    }

    public void setOffset(float x, float y, float z) {
        this.offset = new AVector3f(x, y, z);
    }

    public void setScale(AVector3f vector3) {
        this.scale = new AVector3f(vector3.x, vector3.y, vector3.z);
    }

    public void setScale(float x, float y, float z) {
        this.scale = new AVector3f(x, y, z);
    }

    public void setCustomRotation(AVector3f customRotation) {
        this.customRotation = customRotation;
    }

    public void setCustomRotation(float x, float y, float z) {
        this.customRotation = new AVector3f(x, y, z);
    }

    public void setCustomScale(AVector3f customScale) {
        this.customScale = customScale;
    }

    public void setCustomScale(float x, float y, float z) {
        this.customScale = new AVector3f(x, y, z);
    }

    public void setCustomOffset(AVector3f customOffset) {
        this.customOffset = customOffset;
    }

    public void setCustomOffset(float x, float y, float z) {
        this.customOffset = new AVector3f(x, y, z);
    }

    public AVector3f getScale() {
        return this.scale;
    }

    public AVector3f getOffset() {
        return this.offset;
    }

    public AVector3f getRotation() {
        return this.rotation;
    }

    public AVector3f getCustomRotation() {
        return this.customRotation;
    }

    public AVector3f getCustomScale() {
        return this.customScale;
    }

    public AVector3f getCustomOffset() {
        return this.customOffset;
    }

    public PoseStack.Pose getLastPose() {
        return this.lastPose;
    }
}

