/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import ru.astemir.astemirlib.client.bedrock.json.JsonParser;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelBone;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelCube;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelFactory;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UVType;
import ru.astemir.astemirlib.common.math.AVector3f;

public class BedrockModelParser
implements JsonParser {
    public static BedrockModelFactory parseModel(ResourceLocation location) {
        BedrockModelFactory bedrockModelFactory;
        InputStreamReader reader = new InputStreamReader(Minecraft.m_91087_().m_91098_().m_215595_(location));
        try {
            JsonObject json = GsonHelper.m_13861_((Reader)reader, (boolean)true);
            bedrockModelFactory = BedrockModelParser.parseModel(json);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Error parsing model", e);
            }
        }
        reader.close();
        return bedrockModelFactory;
    }

    private static BedrockModelFactory parseModel(JsonObject object) {
        for (Map.Entry entry : object.entrySet()) {
            if (!((String)entry.getKey()).equals("minecraft:geometry")) continue;
            BedrockModelFactory model = BedrockModelParser.parseModel(GsonHelper.m_13924_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey())));
            return model;
        }
        throw new RuntimeException("No models found");
    }

    private static BedrockModelFactory parseModel(JsonArray subModelArr) {
        JsonObject subModel = GsonHelper.m_13918_((JsonElement)subModelArr.get(0), (String)"member of 'minecraft:geometry'");
        JsonArray bones = GsonHelper.m_13933_((JsonObject)subModel, (String)"bones");
        JsonObject description = GsonHelper.m_13930_((JsonObject)subModel, (String)"description");
        HashMap<String, BedrockModelBone> parts = new HashMap<String, BedrockModelBone>();
        for (JsonElement bone : bones) {
            BedrockModelBone part = BedrockModelParser.parseBone(GsonHelper.m_13918_((JsonElement)bone, (String)"member of 'bones'"));
            parts.put(part.getName(), part);
        }
        ArrayList<BedrockModelBone> rootChildren = new ArrayList<BedrockModelBone>();
        for (BedrockModelBone value : parts.values()) {
            if (!value.getParentName().equals("root")) {
                BedrockModelBone parent = (BedrockModelBone)parts.get(value.getParentName());
                if (parent != null) {
                    parent.addChild(value);
                    continue;
                }
                throw new JsonSyntaxException(String.format("Can't find parent node '%s' for node '%s'", value.getParentName(), value.getName()));
            }
            rootChildren.add(value);
        }
        return BedrockModelParser.makeDefinition(GsonHelper.m_13927_((JsonObject)description, (String)"texture_width"), GsonHelper.m_13927_((JsonObject)description, (String)"texture_height"), rootChildren);
    }

    private static BedrockModelFactory makeDefinition(int textureWidth, int textureHeight, List<BedrockModelBone> roots) {
        BedrockModelBone root = BedrockModelBone.makeRoot();
        root.addChildren(roots);
        return BedrockModelFactory.create(root, textureWidth, textureHeight);
    }

    private static BedrockModelBone parseBone(JsonObject bone) {
        AVector3f pivot = JsonParser.getAsVec3(bone, "pivot");
        AVector3f rotation = JsonParser.getAsVec3(bone, "rotation", new AVector3f(0.0f, 0.0f, 0.0f));
        boolean mirror = GsonHelper.m_13855_((JsonObject)bone, (String)"mirror", (boolean)false);
        boolean neverRender = GsonHelper.m_13855_((JsonObject)bone, (String)"neverRender", (boolean)false);
        String name = GsonHelper.m_13906_((JsonObject)bone, (String)"name");
        String parentName = GsonHelper.m_13851_((JsonObject)bone, (String)"parent", (String)"root");
        ArrayList<BedrockModelBone> children = new ArrayList<BedrockModelBone>();
        ArrayList<BedrockModelCube> cubes = new ArrayList<BedrockModelCube>();
        if (bone.has("cubes")) {
            int i = 0;
            for (JsonElement cubeJson : GsonHelper.m_13933_((JsonObject)bone, (String)"cubes")) {
                JsonObject cubeObject = GsonHelper.m_13918_((JsonElement)cubeJson, (String)"member of 'cubes'");
                AVector3f origin = JsonParser.getAsVec3(cubeObject, "origin");
                AVector3f size = JsonParser.getAsVec3(cubeObject, "size");
                UVType uv = (UVType)GSON.fromJson(cubeObject.get("uv"), UVType.class);
                boolean cubeMirror = GsonHelper.m_13855_((JsonObject)cubeObject, (String)"mirror", (boolean)mirror);
                float inflate = GsonHelper.m_13820_((JsonObject)cubeObject, (String)"inflate", (float)0.0f);
                BedrockModelCube cube = new BedrockModelCube(origin, size, uv, inflate, cubeMirror);
                if (cubeObject.has("rotation")) {
                    AVector3f innerRotation = JsonParser.getAsVec3(cubeObject, "rotation", new AVector3f(0.0f, 0.0f, 0.0f));
                    AVector3f innerPivot = JsonParser.getAsVec3(cubeObject, "pivot", new AVector3f(0.0f, 0.0f, 0.0f));
                    children.add(new BedrockModelBone(Collections.singletonList(cube), innerPivot, innerRotation, false, name + "/synth-" + i, name));
                    ++i;
                    continue;
                }
                cubes.add(cube);
            }
        }
        BedrockModelBone part = new BedrockModelBone(cubes, pivot, rotation, neverRender, name, parentName);
        part.addChildren(children);
        return part;
    }
}

