/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data.dynamic;

import com.google.common.collect.Lists;
import java.util.List;
import me.wesley1808.servercore.common.config.data.dynamic.Setting;
import me.wesley1808.servercore.common.config.impl.dynamic.DynamicConfigImpl;
import me.wesley1808.servercore.common.config.impl.dynamic.SettingImpl;
import me.wesley1808.servercore.common.config.serialization.Validators;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.ConfValidator;
import space.arim.dazzleconf.annote.IntegerRange;
import space.arim.dazzleconf.annote.SubSection;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

public interface DynamicConfig {
    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="enabled")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Enables dynamic performance checks."})
    public boolean enabled();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="target-mspt")
    @ConfDefault.DefaultInteger(value=35)
    @IntegerRange(min=2L)
    @ConfComments(value={"The average MSPT to target."})
    public int targetMspt();

    @AnnotationBasedSorter.Order(value=3)
    @ConfKey(value="dynamic-settings")
    @ConfDefault.DefaultObject(value="defaultSettings")
    @ConfValidator(value=Validators.UniqueSettings.class)
    @ConfComments(value={"The settings that will be decreased when the server is overloaded, in the specified order.", "Removing a setting from the list will disable it.", "\u25ba max = The maximum value the server will increase the setting to.", "\u25ba min = The minimum value the server will decrease the setting to.", "\u25ba increment = The amount the setting will be increased or decreased by.", "\u25ba interval = The amount of seconds between each check to increase or decrease."})
    public List<@SubSection Setting> settings();

    default public DynamicConfig optimizedCopy() {
        return new DynamicConfigImpl(this);
    }

    public static List<Setting> defaultSettings() {
        return Lists.newArrayList((Object[])new Setting[]{new SettingImpl(DynamicSetting.CHUNK_TICK_DISTANCE, 10, 2, 1, 15), new SettingImpl(DynamicSetting.MOBCAP_PERCENTAGE, 100, 30, 10, 15), new SettingImpl(DynamicSetting.SIMULATION_DISTANCE, 10, 2, 1, 15), new SettingImpl(DynamicSetting.VIEW_DISTANCE, 10, 2, 1, 150)});
    }
}

