/*
 * Decompiled with CFR 0.152.
 */
package com.armordamagescale.mixin;

import com.armordamagescale.ArmorDamage;
import com.armordamagescale.config.CommonConfiguration;
import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.parser.ParseException;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityArmorMixin
extends Entity {
    public LivingEntityArmorMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract void m_6472_(DamageSource var1, float var2);

    @Shadow
    public abstract int m_21230_();

    @Shadow
    public abstract double m_21133_(Attribute var1);

    @Shadow
    public abstract float m_21233_();

    @ModifyVariable(method={"actuallyHurt"}, argsOnly=true, at=@At(value="HEAD"), ordinal=0)
    private float brutalbosses$onhurt(float damageOrg, DamageSource source, float damage) throws EvaluationException, ParseException {
        if (source.m_7639_() instanceof Player) {
            if (Float.isInfinite(damageOrg) || Float.isNaN(damageOrg) || damageOrg < 0.0f) {
                ArmorDamage.LOGGER.warn("Bad damage value input:" + damageOrg, (Throwable)new Exception());
                return 0.0f;
            }
            float normalizedDamage = ((CommonConfiguration)ArmorDamage.config.getCommonConfig()).playerdamagereduction.with("damage", (Object)Float.valueOf(damageOrg)).evaluate().getNumberValue().floatValue();
            if (((CommonConfiguration)ArmorDamage.config.getCommonConfig()).debugprint) {
                ArmorDamage.LOGGER.info("Normalizing player damage from: " + damage + " to:" + normalizedDamage);
            }
            return normalizedDamage;
        }
        return damageOrg;
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void armordamage$getDamageAfterArmorAbsorb(DamageSource damageSource, float damage, CallbackInfoReturnable<Float> cir) throws EvaluationException, ParseException {
        if (!damageSource.m_269533_(DamageTypeTags.f_268490_)) {
            float toughness;
            if (Float.isInfinite(damage) || Float.isNaN(damage)) {
                ArmorDamage.LOGGER.warn("Bad damage value input:" + damage, (Throwable)new Exception());
                cir.setReturnValue((Object)Float.valueOf(0.0f));
                return;
            }
            Object log = "";
            if (((CommonConfiguration)ArmorDamage.config.getCommonConfig()).debugprint) {
                log = (String)log + "Calculating damage for attack: origin:" + damageSource.m_7639_() + " target:" + this + ", dmgtype:" + damageSource.m_19385_() + ", dmg:" + damage;
            }
            this.m_6472_(damageSource, damage);
            float armorValue = this.m_21230_();
            float modamage = damage;
            if (armorValue > 0.0f) {
                modamage = ((CommonConfiguration)ArmorDamage.config.getCommonConfig()).armordamagereduction.with("armor", (Object)Float.valueOf(armorValue)).with("damage", (Object)Float.valueOf(damage)).evaluate().getNumberValue().floatValue();
                if (((CommonConfiguration)ArmorDamage.config.getCommonConfig()).debugprint) {
                    log = (String)log + ", Armorvalue:" + armorValue + ", dmg after armor reduction:" + modamage;
                }
            }
            if ((toughness = (float)this.m_21133_(Attributes.f_22285_)) > 0.0f) {
                float hitpct = Math.max(0.0f, Math.min(1.0f, modamage / this.m_21233_()));
                ((CommonConfiguration)ArmorDamage.config.getCommonConfig()).thoughnessdamagereduction.with("toughness", (Object)Float.valueOf(toughness));
                ((CommonConfiguration)ArmorDamage.config.getCommonConfig()).thoughnessdamagereduction.with("hitpct", (Object)Float.valueOf(hitpct));
                ((CommonConfiguration)ArmorDamage.config.getCommonConfig()).thoughnessdamagereduction.with("damage", (Object)Float.valueOf(modamage));
                modamage = ((CommonConfiguration)ArmorDamage.config.getCommonConfig()).thoughnessdamagereduction.evaluate().getNumberValue().floatValue();
                if (((CommonConfiguration)ArmorDamage.config.getCommonConfig()).debugprint) {
                    log = (String)log + " Toughnessvalue:" + toughness + " dmg after toughness reduction:" + modamage;
                }
            }
            cir.setReturnValue((Object)Float.valueOf(Math.max(0.5f, modamage)));
            if (((CommonConfiguration)ArmorDamage.config.getCommonConfig()).debugprint && !((String)log).isEmpty()) {
                ArmorDamage.LOGGER.info((String)log);
            }
        }
    }
}

