/*
 * Decompiled with CFR 0.152.
 */
package com.armordamagescale.config;

import com.armordamagescale.ArmorDamage;
import com.cupboard.config.ICommonConfig;
import com.ezylang.evalex.Expression;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class CommonConfiguration
implements ICommonConfig {
    public static final String FORMULA_ARMOR_ARG = "armor";
    public static final String FORMULA_TOUGHNESS_ARG = "toughness";
    public static final String FORMULA_HITPCT_ARG = "hitpct";
    public static final String FORMULA_DAMAGE_ARG = "damage";
    public Expression armordamagereduction = null;
    public String armorFormula = "damage*(15/(armor+15))";
    public Expression thoughnessdamagereduction = null;
    public String toughnessFormula = "damage*(1/(toughness/10+1)*hitpct+(1-hitpct))";
    public Expression playerdamagereduction = null;
    public String playerdamageFormula = "damage*(100/(damage+100))";
    public boolean debugprint = false;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Armor damage reduction formula. Input values: armor,damage Default formula:" + this.armorFormula);
        entry.addProperty("armorFormula", this.armorFormula);
        root.add("armorFormula", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Armor toughness reduces damage in relation to percent health lost.Input values:hitpct(0-1), toughness, damage. Default: " + this.toughnessFormula);
        entry2.addProperty("toughnessFormula", this.toughnessFormula);
        root.add("toughnessFormula", (JsonElement)entry2);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Player damage normalization, scales player damage caused to better balance modded weapons and combat. Input values:damage . To disable put just: damage Default formula:" + this.playerdamageFormula);
        entry4.addProperty("playerdamageFormula", this.playerdamageFormula);
        root.add("playerdamageFormula", (JsonElement)entry4);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Set to true to enable log debug output, default: false.");
        entry3.addProperty("debugprint", Boolean.valueOf(this.debugprint));
        root.add("debugprint", (JsonElement)entry3);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            ArmorDamage.LOGGER.error("Config file was empty!");
            return;
        }
        String armorFormula = data.get("armorFormula").getAsJsonObject().get("armorFormula").getAsString();
        this.armordamagereduction = new Expression(armorFormula);
        String toughnessFormula = data.get("toughnessFormula").getAsJsonObject().get("toughnessFormula").getAsString();
        this.thoughnessdamagereduction = new Expression(toughnessFormula);
        if (!armorFormula.contains(FORMULA_DAMAGE_ARG) && !toughnessFormula.contains(FORMULA_DAMAGE_ARG)) {
            throw new RuntimeException("Outdated config format, resetting config");
        }
        this.armorFormula = armorFormula;
        this.toughnessFormula = toughnessFormula;
        this.playerdamageFormula = data.get("playerdamageFormula").getAsJsonObject().get("playerdamageFormula").getAsString();
        this.playerdamagereduction = new Expression(this.playerdamageFormula);
        this.debugprint = data.get("debugprint").getAsJsonObject().get("debugprint").getAsBoolean();
    }
}

