/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.service;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;

public class FabricASMFixer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> FABRIC_ASM_MODIDS = Set.of("mm", "mm_shedaniel");
    private static final String MINECRAFT_MODULE = "minecraft";
    public static final List<URL> URLS = new ArrayList<URL>();

    public static Consumer<URL> fishAddURL() {
        return URLS::add;
    }

    public static String flattenMixinClass(String name) {
        return name.replace('/', '_');
    }

    public static void permitEnumSubclass(ClassNode enumNode, String anonymousClassName) {
        if (enumNode.permittedSubclasses != null) {
            enumNode.permittedSubclasses.add(anonymousClassName);
        }
    }

    public static void injectMinecraftModuleReader() {
        try {
            ModuleReference reference;
            if (FABRIC_ASM_MODIDS.stream().noneMatch(FabricLoader.getInstance()::isModLoaded)) {
                return;
            }
            ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.GAME).orElseThrow();
            ResolvedModule resolvedModule = layer.configuration().findModule(MINECRAFT_MODULE).orElseThrow();
            Class<?> jarModuleReference = Class.forName("cpw.mods.cl.JarModuleFinder$JarModuleReference");
            if (!jarModuleReference.isInstance(reference = resolvedModule.reference())) {
                LOGGER.error("Minecraft module does not contain a jar module reference");
                return;
            }
            Field jarField = jarModuleReference.getDeclaredField("jar");
            SecureJar.ModuleDataProvider originalProvider = (SecureJar.ModuleDataProvider)UnsafeHacks.getField((Field)jarField, (Object)reference);
            ModuleDataProviderWrapper wrappedProvider = new ModuleDataProviderWrapper(originalProvider);
            UnsafeHacks.setField((Field)jarField, (Object)reference, (Object)wrappedProvider);
            LOGGER.debug("Successfully replaced minecraft module reference jar");
        }
        catch (Throwable t) {
            LOGGER.error("Error injecting Fabric ASM minecraft module reader", t);
        }
    }

    private static Optional<InputStream> findGeneratedFile(String name) {
        for (URL url : URLS) {
            try {
                URL pathUrl = new URL(url, name);
                URLConnection connection = pathUrl.openConnection();
                if (connection == null) continue;
                return Optional.of(connection.getInputStream());
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public record ModuleDataProviderWrapper(SecureJar.ModuleDataProvider provider) implements SecureJar.ModuleDataProvider
    {
        public Optional<InputStream> open(String name) {
            Optional<InputStream> file = this.provider.open(name);
            return file.isEmpty() ? FabricASMFixer.findGeneratedFile(name) : file;
        }

        public String name() {
            return this.provider.name();
        }

        public ModuleDescriptor descriptor() {
            return this.provider.descriptor();
        }

        public URI uri() {
            return this.provider.uri();
        }

        public Optional<URI> findFile(String name) {
            return this.provider.findFile(name);
        }

        public Manifest getManifest() {
            return this.provider.getManifest();
        }

        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return this.provider.verifyAndGetSigners(cname, bytes);
        }
    }

    private static class FabricASMGeneratedClassesProvider
    implements SecureJar.ModuleDataProvider {
        private static final Set<String> GEN_PACKAGES = Set.of("com.chocohead.gen.mixin", "me.shedaniel.gen.mixin");
        private ModuleDescriptor descriptor;

        private FabricASMGeneratedClassesProvider() {
        }

        public String name() {
            return "fabric_asm_generated_classes";
        }

        public ModuleDescriptor descriptor() {
            if (this.descriptor == null) {
                this.descriptor = ModuleDescriptor.newAutomaticModule(this.name()).packages(GEN_PACKAGES).build();
            }
            return this.descriptor;
        }

        public URI uri() {
            return (URI)LamdbaExceptionUtils.uncheck(() -> new URI("file:///~nonexistent"));
        }

        public Optional<URI> findFile(String name) {
            return Optional.empty();
        }

        public Optional<InputStream> open(String name) {
            return FabricASMFixer.findGeneratedFile(name);
        }

        public Manifest getManifest() {
            return new Manifest();
        }

        public CodeSigner[] verifyAndGetSigners(String cname, byte[] bytes) {
            return new CodeSigner[0];
        }
    }

    public static class FabricASMGeneratedClassesSecureJar
    implements SecureJar {
        private final SecureJar.ModuleDataProvider moduleDataProvider = new FabricASMGeneratedClassesProvider();

        public SecureJar.ModuleDataProvider moduleDataProvider() {
            return this.moduleDataProvider;
        }

        public Path getPrimaryPath() {
            return Path.of(this.moduleDataProvider().uri());
        }

        public CodeSigner[] getManifestSigners() {
            return new CodeSigner[0];
        }

        public SecureJar.Status verifyPath(Path path) {
            return SecureJar.Status.NONE;
        }

        public SecureJar.Status getFileStatus(String name) {
            return SecureJar.Status.NONE;
        }

        public Attributes getTrustedManifestEntries(String name) {
            return new Attributes();
        }

        public boolean hasSecurityData() {
            return false;
        }

        public Set<String> getPackages() {
            return this.moduleDataProvider().descriptor().packages();
        }

        public List<SecureJar.Provider> getProviders() {
            return List.of();
        }

        public String name() {
            return this.moduleDataProvider().name();
        }

        public Path getPath(String first, String ... rest) {
            return this.getPrimaryPath();
        }

        public Path getRootPath() {
            return this.getPrimaryPath();
        }
    }
}

