/*
 * Decompiled with CFR 0.152.
 */
package me.kall.doespotatotick.mixin.impl;

import me.kall.doespotatotick.events.PlayerTracker;
import me.kall.doespotatotick.mixin.impl.ext.EntityMixin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends EntityMixin {
    @Unique
    protected int dpt$lastHeight = Integer.MAX_VALUE;
    @Unique
    private long dpt$lastChunk;

    @Override
    protected void beforePosChange(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        this.dpt$lastChunk = ChunkPos.m_45589_((int)(player.m_20183_().m_123341_() >> 4), (int)(player.m_20183_().m_123343_() >> 4));
    }

    @Override
    protected void afterPosChange(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        int currentHeight = player.m_146904_();
        MinecraftServer server = player.f_8924_;
        if (server == null) {
            return;
        }
        ResourceLocation dim = player.m_9236_().m_46472_().m_135782_();
        if (Math.abs(currentHeight - this.dpt$lastHeight) >= 4) {
            server.execute(() -> PlayerTracker.UPDATE_REQUIRED.add(dim));
            this.dpt$lastHeight = currentHeight;
            return;
        }
        long currentChunk = ChunkPos.m_45589_((int)(player.m_20183_().m_123341_() >> 4), (int)(player.m_20183_().m_123343_() >> 4));
        if (this.dpt$lastChunk != currentChunk) {
            server.execute(() -> PlayerTracker.UPDATE_REQUIRED.add(dim));
        }
    }
}

