/*
 * Decompiled with CFR 0.152.
 */
package me.kall.doespotatotick.integration.sodium;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.kall.doespotatotick.config.TickConfig;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import org.embeddedt.embeddium.api.OptionGUIConstructionEvent;
import org.embeddedt.embeddium.client.gui.options.OptionIdentifier;
import org.jetbrains.annotations.NotNull;

public class SodiumIntegration {
    private static final SodiumOptionsStorage storage = new SodiumOptionsStorage();

    @NotNull
    private static List<OptionGroup> groups() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionImpl<SodiumGameOptions, Boolean> skipRenderingUntickable = SodiumIntegration.booleanOptionFor("doespotatotick.skip.untickable", "doespotatotick.skip.untickable.tooltip", TickConfig.Client.SKIP_RENDERING_UNTICKABLE, OptionImpact.HIGH);
        OptionImpl<SodiumGameOptions, Boolean> projectileWeaponSkip = SodiumIntegration.booleanOptionFor("doespotatotick.skip.shoot", "doespotatotick.skip.shoot.tooltip", TickConfig.Client.PROJECTILE_WEAPON_SKIP, OptionImpact.LOW);
        groups.add(OptionGroup.createBuilder().add(skipRenderingUntickable).add(projectileWeaponSkip).build());
        return groups;
    }

    private static OptionImpl<SodiumGameOptions, Boolean> booleanOptionFor(String name, String tooltip, ForgeConfigSpec.BooleanValue config, OptionImpact impact) {
        return OptionImpl.createBuilder(Boolean.class, (OptionStorage)storage).setName((Component)Component.m_237115_((String)name)).setTooltip((Component)Component.m_237115_((String)tooltip)).setControl(TickBoxControl::new).setBinding((sodiumGameOptions, value) -> config.set(value), sodiumGameOptions -> (Boolean)config.get()).setImpact(impact).build();
    }

    private static void onPageLoad(@NotNull OptionGUIConstructionEvent event) {
        event.addPage(new OptionPage(OptionIdentifier.create((String)"doespotatotick", (String)"config"), (Component)Component.m_237115_((String)"doespotatotick.page"), ImmutableList.copyOf(SodiumIntegration.groups())));
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(SodiumIntegration::onPageLoad);
    }
}

