/*
 * Decompiled with CFR 0.152.
 */
package me.kall.doespotatotick.events;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import me.kall.doespotatotick.DoesPotatoTick;
import me.kall.doespotatotick.config.ConfigConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public class PlayerTracker {
    public static final Object2ObjectMap<ResourceLocation, Long2ObjectMap<Range>> ACTIVE_CHUNKS = new Object2ObjectOpenHashMap();
    public static final Set<ResourceLocation> UPDATE_REQUIRED = new ObjectOpenHashSet();

    public static void login(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.f_8924_.execute(() -> UPDATE_REQUIRED.add(player2.m_9236_().m_46472_().m_135782_()));
        }
    }

    public static void dimChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.f_8924_.execute(() -> UPDATE_REQUIRED.add(event.getTo().m_135782_()));
        }
    }

    public static void tickLevel(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side != LogicalSide.SERVER) {
            return;
        }
        if (DoesPotatoTick.invalidThread()) {
            return;
        }
        Level level = event.level;
        ResourceLocation dimID = level.m_46472_().m_135782_();
        if (!UPDATE_REQUIRED.remove(dimID)) {
            return;
        }
        Long2ObjectMap chunkMap = (Long2ObjectMap)ACTIVE_CHUNKS.computeIfAbsent((Object)dimID, k -> new Long2ObjectOpenHashMap());
        chunkMap.clear();
        int horizontal = ConfigConstants.horizontalChunks;
        int height = ConfigConstants.verticalChunks * 16;
        for (Player player : level.m_6907_()) {
            ChunkPos center = player.m_146902_();
            int y = player.m_146904_();
            int minY = y - height;
            int maxY = y + height;
            for (int dx = -horizontal; dx <= horizontal; ++dx) {
                for (int dz = -horizontal; dz <= horizontal; ++dz) {
                    long chunk = ChunkPos.m_45589_((int)(center.f_45578_ + dx), (int)(center.f_45579_ + dz));
                    Range yRange = (Range)chunkMap.get(chunk);
                    if (yRange == null) {
                        yRange = new Range(minY, maxY);
                        chunkMap.put(chunk, (Object)yRange);
                        continue;
                    }
                    yRange.min = Math.min(yRange.min, minY);
                    yRange.max = Math.max(yRange.max, maxY);
                }
            }
        }
    }

    public static boolean include(ResourceLocation dimID, int entityHeight, long entityChunk) {
        Long2ObjectMap chunkMap = (Long2ObjectMap)ACTIVE_CHUNKS.get((Object)dimID);
        if (chunkMap == null) {
            return false;
        }
        Range range = (Range)chunkMap.get(entityChunk);
        if (range == null) {
            return false;
        }
        return entityHeight >= range.min && entityHeight <= range.max;
    }

    public static final class Range {
        public int min;
        public int max;

        public Range(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

