/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.integration.jei;

import com.teamabnormals.clayworks.common.item.crafting.BakingRecipe;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import com.teamabnormals.clayworks.integration.jei.ClayworksPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BakingCategory
implements IRecipeCategory<BakingRecipe> {
    public static final String TRANSLATION = "gui.clayworks.category.baking";
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    protected final IGuiHelper guiHelper;
    protected final int regularCookTime;
    protected final IDrawableAnimated animatedFlame;

    public BakingCategory(IGuiHelper guiHelper) {
        this(guiHelper, TRANSLATION, 100, 82, 54);
    }

    public BakingCategory(IGuiHelper guiHelper, String translationKey, int regularCookTime, int width, int height) {
        this.background = guiHelper.createBlankDrawable(width, height);
        this.regularCookTime = regularCookTime;
        this.icon = guiHelper.createDrawableItemLike((ItemLike)ClayworksBlocks.KILN.get());
        this.localizedName = Component.m_237115_((String)translationKey);
        this.guiHelper = guiHelper;
        this.animatedFlame = guiHelper.createAnimatedRecipeFlame(300);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(BakingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 1, 20);
        this.drawExperience(recipe, guiGraphics, 0);
        this.drawCookTime(recipe, guiGraphics, 45);
    }

    protected void drawExperience(BakingRecipe recipe, GuiGraphics guiGraphics, int y) {
        float experience = recipe.m_43750_();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            guiGraphics.m_280614_(fontRenderer, (Component)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(BakingRecipe recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = recipe.m_43753_();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(fontRenderer, (Component)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BakingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setStandardSlotBackground().addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).setOutputSlotBackground().addItemStack(ClayworksRecipes.getResultItem(recipe));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, BakingRecipe recipe, IFocusGroup focuses) {
        acceptor.addWidget(this.createCookingArrowWidget(recipe, 26, 17));
    }

    public boolean isHandled(BakingRecipe recipe) {
        return !recipe.m_5598_();
    }

    public RecipeType<BakingRecipe> getRecipeType() {
        return ClayworksPlugin.BAKING;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getRegistryName(BakingRecipe recipe) {
        return recipe.m_6423_();
    }

    protected IRecipeWidget createCookingArrowWidget(BakingRecipe recipe, int x, int y) {
        int cookTime = recipe.m_43753_();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        IDrawableAnimated recipeArrow = this.guiHelper.createAnimatedRecipeArrow(cookTime);
        return this.guiHelper.createWidgetFromDrawable((IDrawable)recipeArrow, x, y);
    }
}

