/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.registry;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.teamabnormals.clayworks.common.item.crafting.BakingRecipe;
import com.teamabnormals.clayworks.common.item.crafting.DecoratedPotColoring;
import com.teamabnormals.clayworks.core.Clayworks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ClayworksRecipes {
    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_8043_(registryAccess);
    }

    @Mod.EventBusSubscriber(modid="clayworks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClayworksRecipeCategories {
        public static final Supplier<RecipeBookCategories> KILN_SEARCH = Suppliers.memoize(() -> RecipeBookCategories.create((String)"KILN_SEARCH", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42522_)}));
        public static final Supplier<RecipeBookCategories> KILN_BLOCKS = Suppliers.memoize(() -> RecipeBookCategories.create((String)"KILN_BLOCKS", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50076_)}));
        public static final Supplier<RecipeBookCategories> KILN_MISC = Suppliers.memoize(() -> RecipeBookCategories.create((String)"KILN_MISC", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42460_)}));

        @SubscribeEvent
        public static void registerCategories(RegisterRecipeBookCategoriesEvent event) {
            event.registerBookCategories(Clayworks.RECIPE_TYPE_BAKING, (List)ImmutableList.of((Object)KILN_SEARCH.get(), (Object)KILN_BLOCKS.get(), (Object)KILN_MISC.get()));
            event.registerAggregateCategory(KILN_SEARCH.get(), (List)ImmutableList.of((Object)KILN_BLOCKS.get(), (Object)KILN_MISC.get()));
            event.registerRecipeCategoryFinder((RecipeType)ClayworksRecipeTypes.BAKING.get(), recipe -> ClayworksRecipes.getResultItem(recipe).m_41720_() instanceof BlockItem ? KILN_BLOCKS.get() : KILN_MISC.get());
        }
    }

    public static class ClayworksRecipeTypes {
        public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"clayworks");
        public static final RegistryObject<RecipeType<BakingRecipe>> BAKING = RECIPE_TYPES.register("baking", () -> new RecipeType<BakingRecipe>(){

            public String toString() {
                return "clayworks:baking";
            }
        });
    }

    public static class ClayworksRecipeSerializers {
        public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"clayworks");
        public static final RegistryObject<SimpleCookingSerializer<BakingRecipe>> BAKING_RECIPE = RECIPE_SERIALIZERS.register("baking", () -> new SimpleCookingSerializer(BakingRecipe::new, 100));
        public static final RegistryObject<SimpleCraftingRecipeSerializer<DecoratedPotColoring>> DECORATED_POT_COLORING = RECIPE_SERIALIZERS.register("crafting_special_decoratedpotcoloring", () -> new SimpleCraftingRecipeSerializer(DecoratedPotColoring::new));
    }
}

