/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.registry;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ClayworksMaterials {
    public static final Map<Pair<ResourceKey<String>, DyeColor>, Material> DECORATED_POT_MATERIALS = ClayworksMaterials.formDecoratedPotMaterials();

    private static Map<Pair<ResourceKey<String>, DyeColor>, Material> formDecoratedPotMaterials() {
        HashMap map = Maps.newHashMap();
        for (ResourceKey key : BuiltInRegistries.f_271353_.m_214010_()) {
            for (DyeColor color : DyeColor.values()) {
                map.put(Pair.of((Object)key, (Object)color), ClayworksMaterials.createDecoratedPotMaterial((ResourceKey<String>)key, color));
            }
        }
        return map;
    }

    private static Material createDecoratedPotMaterial(ResourceKey<String> name, DyeColor color) {
        return new Material(Sheets.f_271463_, name.m_135782_().m_246208_("entity/decorated_pot/").m_266382_("_" + color.m_41065_()));
    }

    public static Material createTrimMaterial(ResourceLocation location, @Nullable DyeColor color) {
        return new Material(Sheets.f_271463_, location.m_246208_("entity/decorated_pot/").m_266382_((String)(color != null ? "_" + color.m_41065_() : "")));
    }

    public static Material createTrimMaterial(ResourceLocation location, String trimMaterial) {
        return new Material(Sheets.f_271463_, location.m_266382_("_" + trimMaterial));
    }

    @Nullable
    public static Material getDecoratedPotMaterial(@Nullable ResourceKey<String> string, DyeColor color) {
        return string == null ? null : DECORATED_POT_MATERIALS.get(Pair.of(string, (Object)color));
    }
}

