/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.other.ClayworksBlockFamilies;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

public class ClayworksRecipeProvider
extends BlueprintRecipeProvider {
    public static final ConfigValueCondition KILN_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.kiln, "kiln");
    public static final ConfigValueCondition CHISELED_BRICKS_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.chiseledBricks, "chiseled_bricks");
    public static final ConfigValueCondition GLAZED_TERRACOTTA_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.glazedTerracotta, "glazed_terracotta");
    public static final ConfigValueCondition TERRACOTTA_VARIANTS_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.terracottaVariants, "terracotta_variants");
    public static final ConfigValueCondition TERRACOTTA_BRICKS_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.terracottaBricks, "terracotta_bricks");
    public static final ConfigValueCondition CONCRETE_CONFIG = ClayworksRecipeProvider.config(ClayworksConfig.COMMON.concrete, "concrete");
    public static final BlueprintAndCondition KILN_COMPAT = new BlueprintAndCondition(new ICondition[]{new ModLoadedCondition("clayworks"), KILN_CONFIG});

    public ClayworksRecipeProvider(PackOutput output) {
        super("clayworks", output);
    }

    public void m_245200_(Consumer<FinishedRecipe> consumer) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.DECORATIONS, (ICondition)KILN_CONFIG, (RecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ClayworksBlocks.KILN.get())).m_206416_(Character.valueOf('#'), ItemTags.f_13166_).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50094_).m_126127_(Character.valueOf('B'), (ItemLike)Blocks.f_220844_).m_126130_("###").m_126130_("#X#").m_126130_("BBB").m_126132_("has_cobblestone", (CriterionTriggerInstance)ClayworksRecipeProvider.m_206406_((TagKey)ItemTags.f_13166_)));
        ClayworksRecipeProvider.generateKilnRecipes(consumer);
        SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)ClayworksRecipes.ClayworksRecipeSerializers.DECORATED_POT_COLORING.get())).m_126359_(consumer, "clayworks:decorated_pot_coloring");
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)CHISELED_BRICKS_CONFIG, (RecipeBuilder)ClayworksRecipeProvider.m_246451_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ClayworksBlocks.CHISELED_BRICKS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50410_})).m_126132_(ClayworksRecipeProvider.m_176602_((ItemLike)Blocks.f_50410_), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)Blocks.f_50410_)));
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)CHISELED_BRICKS_CONFIG, (ItemLike)ClayworksBlocks.CHISELED_BRICKS.get(), (ItemLike)Blocks.f_50076_);
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.DECORATIONS, (ICondition)GLAZED_TERRACOTTA_CONFIG, (RecipeBuilder)SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50352_}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ClayworksBlocks.GLAZED_TERRACOTTA.get()).m_5456_(), (float)0.1f, (int)200).m_126132_("has_terracotta", (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)Blocks.f_50352_)));
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)CONCRETE_CONFIG, (RecipeBuilder)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ClayworksBlocks.CONCRETE_POWDER.get()), (int)8).m_126211_((ItemLike)Blocks.f_49992_, 4).m_126211_((ItemLike)Blocks.f_49994_, 4).m_126145_("concrete_powder").m_126132_("has_sand", (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)Blocks.f_49992_)).m_126132_("has_gravel", (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)Blocks.f_49994_)));
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50505_, (ItemLike)Blocks.f_50574_, (ItemLike)Items.f_42498_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50501_, (ItemLike)Blocks.f_50517_, (ItemLike)Items.f_42494_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50502_, (ItemLike)Blocks.f_50518_, (ItemLike)Items.f_42495_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50499_, (ItemLike)Blocks.f_50515_, (ItemLike)Items.f_42492_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50497_, (ItemLike)Blocks.f_50513_, (ItemLike)Items.f_42490_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50503_, (ItemLike)Blocks.f_50519_, (ItemLike)Items.f_42496_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50545_, (ItemLike)Blocks.f_50509_, (ItemLike)Items.f_42538_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50498_, (ItemLike)Blocks.f_50514_, (ItemLike)Items.f_42491_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50495_, (ItemLike)Blocks.f_50511_, (ItemLike)Items.f_42540_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50544_, (ItemLike)Blocks.f_50508_, (ItemLike)Items.f_42537_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50543_, (ItemLike)Blocks.f_50507_, (ItemLike)Items.f_42536_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50496_, (ItemLike)Blocks.f_50512_, (ItemLike)Items.f_42489_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50500_, (ItemLike)Blocks.f_50516_, (ItemLike)Items.f_42493_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50504_, (ItemLike)Blocks.f_50573_, (ItemLike)Items.f_42497_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50542_, (ItemLike)Blocks.f_50506_, (ItemLike)Items.f_42535_);
        ClayworksRecipeProvider.coloredConcreteFromConcreteAndDye(consumer, (ItemLike)Blocks.f_50494_, (ItemLike)Blocks.f_50510_, (ItemLike)Items.f_42539_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50352_, ClayworksBlockFamilies.TERRACOTTA, ClayworksBlockFamilies.TERRACOTTA_BRICKS, null);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50287_, ClayworksBlockFamilies.WHITE_TERRACOTTA, ClayworksBlockFamilies.WHITE_TERRACOTTA_BRICKS, Items.f_42535_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50288_, ClayworksBlockFamilies.ORANGE_TERRACOTTA, ClayworksBlockFamilies.ORANGE_TERRACOTTA_BRICKS, Items.f_42536_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50289_, ClayworksBlockFamilies.MAGENTA_TERRACOTTA, ClayworksBlockFamilies.MAGENTA_TERRACOTTA_BRICKS, Items.f_42537_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50290_, ClayworksBlockFamilies.LIGHT_BLUE_TERRACOTTA, ClayworksBlockFamilies.LIGHT_BLUE_TERRACOTTA_BRICKS, Items.f_42538_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50291_, ClayworksBlockFamilies.YELLOW_TERRACOTTA, ClayworksBlockFamilies.YELLOW_TERRACOTTA_BRICKS, Items.f_42539_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50292_, ClayworksBlockFamilies.LIME_TERRACOTTA, ClayworksBlockFamilies.LIME_TERRACOTTA_BRICKS, Items.f_42540_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50293_, ClayworksBlockFamilies.PINK_TERRACOTTA, ClayworksBlockFamilies.PINK_TERRACOTTA_BRICKS, Items.f_42489_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50294_, ClayworksBlockFamilies.GRAY_TERRACOTTA, ClayworksBlockFamilies.GRAY_TERRACOTTA_BRICKS, Items.f_42490_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50295_, ClayworksBlockFamilies.LIGHT_GRAY_TERRACOTTA, ClayworksBlockFamilies.LIGHT_GRAY_TERRACOTTA_BRICKS, Items.f_42491_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50296_, ClayworksBlockFamilies.CYAN_TERRACOTTA, ClayworksBlockFamilies.CYAN_TERRACOTTA_BRICKS, Items.f_42492_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50297_, ClayworksBlockFamilies.PURPLE_TERRACOTTA, ClayworksBlockFamilies.PURPLE_TERRACOTTA_BRICKS, Items.f_42493_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50298_, ClayworksBlockFamilies.BLUE_TERRACOTTA, ClayworksBlockFamilies.BLUE_TERRACOTTA_BRICKS, Items.f_42494_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50299_, ClayworksBlockFamilies.BROWN_TERRACOTTA, ClayworksBlockFamilies.BROWN_TERRACOTTA_BRICKS, Items.f_42495_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50300_, ClayworksBlockFamilies.GREEN_TERRACOTTA, ClayworksBlockFamilies.GREEN_TERRACOTTA_BRICKS, Items.f_42496_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50301_, ClayworksBlockFamilies.RED_TERRACOTTA, ClayworksBlockFamilies.RED_TERRACOTTA_BRICKS, Items.f_42497_);
        ClayworksRecipeProvider.terracottaBricksRecipes(consumer, Blocks.f_50302_, ClayworksBlockFamilies.BLACK_TERRACOTTA, ClayworksBlockFamilies.BLACK_TERRACOTTA_BRICKS, Items.f_42498_);
    }

    public static void generateKilnRecipes(Consumer<FinishedRecipe> consumer) {
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (TagKey<Item>)ItemTags.f_273858_, "has_smelts_to_glass", (ItemLike)Blocks.f_50058_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.MISC, (TagKey<Item>)ItemTags.f_13181_, "has_log", (ItemLike)Items.f_42414_, 0.15f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50057_, (ItemLike)Blocks.f_50056_, 0.15f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.MISC, (ItemLike)Blocks.f_50567_, (ItemLike)Items.f_42540_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.MISC, (ItemLike)Blocks.f_50128_, (ItemLike)Items.f_42496_, 1.0f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.MISC, (ItemLike)Items.f_42730_, (ItemLike)Items.f_42731_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.MISC, (ItemLike)Items.f_42461_, (ItemLike)Items.f_42460_, 0.3f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50129_, (ItemLike)Blocks.f_50352_, 0.35f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.MISC, (ItemLike)Blocks.f_50134_, (ItemLike)Items.f_42691_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50652_, (ItemLike)Blocks.f_50069_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_152551_, (ItemLike)Blocks.f_152550_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50069_, (ItemLike)Blocks.f_50470_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50062_, (ItemLike)Blocks.f_50471_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50394_, (ItemLike)Blocks.f_50473_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50333_, (ItemLike)Blocks.f_50472_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50137_, (ItemLike)Blocks.f_152597_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50222_, (ItemLike)Blocks.f_50224_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50735_, (ItemLike)Blocks.f_50736_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50197_, (ItemLike)Blocks.f_50713_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_152589_, (ItemLike)Blocks.f_152594_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_152559_, (ItemLike)Blocks.f_152595_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, (ICondition)new BlueprintAndCondition(new ICondition[]{KILN_CONFIG, GLAZED_TERRACOTTA_CONFIG}), RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50352_, (ItemLike)ClayworksBlocks.GLAZED_TERRACOTTA.get(), 0.1f, 100, "clayworks");
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50302_, (ItemLike)Blocks.f_50541_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50298_, (ItemLike)Blocks.f_50537_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50299_, (ItemLike)Blocks.f_50538_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50296_, (ItemLike)Blocks.f_50535_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50294_, (ItemLike)Blocks.f_50533_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50300_, (ItemLike)Blocks.f_50539_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50290_, (ItemLike)Blocks.f_50529_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50295_, (ItemLike)Blocks.f_50534_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50292_, (ItemLike)Blocks.f_50531_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50289_, (ItemLike)Blocks.f_50528_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50288_, (ItemLike)Blocks.f_50527_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50293_, (ItemLike)Blocks.f_50532_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50297_, (ItemLike)Blocks.f_50536_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50301_, (ItemLike)Blocks.f_50540_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50287_, (ItemLike)Blocks.f_50526_, 0.1f, 100);
        ClayworksRecipeProvider.bakingRecipe(consumer, RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50291_, (ItemLike)Blocks.f_50530_, 0.1f, 100);
    }

    private static void terracottaBricksRecipes(Consumer<FinishedRecipe> consumer, Block terracotta, BlockFamily family, BlockFamily bricksFamily, @Nullable Item dye) {
        ClayworksRecipeProvider.generateConditionalRecipes(consumer, family, (ICondition)TERRACOTTA_VARIANTS_CONFIG);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_VARIANTS_CONFIG, (ItemLike)family.m_175952_(BlockFamily.Variant.SLAB), (ItemLike)family.m_175951_(), 2);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_VARIANTS_CONFIG, (ItemLike)family.m_175952_(BlockFamily.Variant.STAIRS), (ItemLike)family.m_175951_());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ICondition)TERRACOTTA_VARIANTS_CONFIG, (ItemLike)family.m_175952_(BlockFamily.Variant.WALL), (ItemLike)family.m_175951_());
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricksFamily.m_175951_(), (int)4).m_126127_(Character.valueOf('#'), (ItemLike)terracotta).m_126130_("##").m_126130_("##").m_126132_(ClayworksRecipeProvider.m_176602_((ItemLike)terracotta), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)terracotta)));
        ClayworksRecipeProvider.generateConditionalRecipes(consumer, bricksFamily, (ICondition)TERRACOTTA_BRICKS_CONFIG);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.SLAB), (ItemLike)bricksFamily.m_175951_(), 2);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.STAIRS), (ItemLike)bricksFamily.m_175951_());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.WALL), (ItemLike)bricksFamily.m_175951_());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.CHISELED), (ItemLike)bricksFamily.m_175951_());
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175951_(), (ItemLike)terracotta);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.SLAB), (ItemLike)terracotta, 2);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.STAIRS), (ItemLike)terracotta);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.DECORATIONS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.WALL), (ItemLike)terracotta);
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (ItemLike)bricksFamily.m_175952_(BlockFamily.Variant.CHISELED), (ItemLike)terracotta);
        if (dye != null) {
            ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)TERRACOTTA_BRICKS_CONFIG, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricksFamily.m_175951_(), (int)8).m_126127_(Character.valueOf('#'), (ItemLike)ClayworksBlocks.TERRACOTTA_BRICKS.get()).m_126127_(Character.valueOf('X'), (ItemLike)dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_terracotta_bricks").m_126132_(ClayworksRecipeProvider.m_176602_((ItemLike)Blocks.f_50352_), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)Blocks.f_50352_)), new ResourceLocation("clayworks", ClayworksRecipeProvider.m_176517_((ItemLike)bricksFamily.m_175951_(), (ItemLike)dye)));
        }
    }

    public static SimpleCookingRecipeBuilder baking(Ingredient ingredient, RecipeCategory category, ItemLike result, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, result.m_5456_() instanceof BlockItem ? CookingBookCategory.BLOCKS : CookingBookCategory.MISC, result, ingredient, experience, cookingTime, (RecipeSerializer)ClayworksRecipes.ClayworksRecipeSerializers.BAKING_RECIPE.get());
    }

    public static void bakingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, TagKey<Item> ingredient, String hasIngredient, ItemLike result, float experience, int cookingTime) {
        ClayworksRecipeProvider.bakingRecipe(consumer, category, ingredient, hasIngredient, result, experience, cookingTime, "clayworks");
    }

    public static void bakingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike ingredient, ItemLike result, float experience, int cookingTime) {
        ClayworksRecipeProvider.bakingRecipe(consumer, category, ingredient, result, experience, cookingTime, "clayworks");
    }

    public static void bakingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, TagKey<Item> ingredient, String hasIngredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.bakingRecipe(consumer, (ICondition)(modid.equals("clayworks") ? KILN_CONFIG : KILN_COMPAT), category, ingredient, hasIngredient, result, experience, cookingTime, modid);
    }

    public static void bakingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike ingredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.bakingRecipe(consumer, (ICondition)(modid.equals("clayworks") ? KILN_CONFIG : KILN_COMPAT), category, ingredient, result, experience, cookingTime, modid);
    }

    public static void bakingRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory category, TagKey<Item> ingredient, String hasIngredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, category, condition, (RecipeBuilder)ClayworksRecipeProvider.baking(Ingredient.m_204132_(ingredient), category, result, experience, cookingTime).m_126132_(hasIngredient, (CriterionTriggerInstance)ClayworksRecipeProvider.m_206406_(ingredient)), new ResourceLocation(modid, ClayworksRecipeProvider.m_176632_((ItemLike)result) + "_from_baking"));
    }

    public static void bakingRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory category, ItemLike ingredient, ItemLike result, float experience, int cookingTime, String modid) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, category, condition, (RecipeBuilder)ClayworksRecipeProvider.baking(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), category, result, experience, cookingTime).m_126132_(ClayworksRecipeProvider.m_176602_((ItemLike)ingredient), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)ingredient)), new ResourceLocation(modid, ClayworksRecipeProvider.m_176632_((ItemLike)result) + "_from_baking"));
    }

    protected static void generateConditionalRecipes(Consumer<FinishedRecipe> consumer, BlockFamily family, ICondition condition) {
        family.m_175954_().forEach((variant, output) -> {
            BiFunction function = (BiFunction)f_244077_.get(variant);
            Block block = ClayworksRecipeProvider.m_176523_((BlockFamily)family, (BlockFamily.Variant)variant);
            if (function != null) {
                RecipeBuilder recipebuilder = (RecipeBuilder)function.apply(output, block);
                family.m_175957_().ifPresent(p_176601_ -> recipebuilder.m_126145_(p_176601_ + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.m_176020_())));
                recipebuilder.m_126132_(family.m_175958_().orElseGet(() -> ClayworksRecipeProvider.lambda$generateConditionalRecipes$1((ItemLike)block)), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)block));
                if (recipebuilder instanceof ShapedRecipeBuilder) {
                    ShapedRecipeBuilder shapedRecipeBuilder = (ShapedRecipeBuilder)recipebuilder;
                    ClayworksRecipeProvider.conditionalRecipe(consumer, condition, shapedRecipeBuilder);
                } else if (recipebuilder instanceof ShapelessRecipeBuilder) {
                    ShapelessRecipeBuilder shapelessRecipeBuilder = (ShapelessRecipeBuilder)recipebuilder;
                    ClayworksRecipeProvider.conditionalRecipe(consumer, condition, shapelessRecipeBuilder);
                }
            }
            if (variant == BlockFamily.Variant.CRACKED) {
                ClayworksRecipeProvider.m_176739_((Consumer)consumer, (ItemLike)output, (ItemLike)block);
                ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, condition, (RecipeBuilder)SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (float)0.1f, (int)200).m_126132_(ClayworksRecipeProvider.m_176602_((ItemLike)block), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)block)));
            }
        });
    }

    protected static void coloredConcreteFromConcreteAndDye(Consumer<FinishedRecipe> consumer, ItemLike concrete, ItemLike concretePowder, ItemLike dye) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)CONCRETE_CONFIG, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)concrete, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)ClayworksBlocks.CONCRETE.get()).m_126127_(Character.valueOf('X'), dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("concrete").m_126132_("has_concrete", (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)((ItemLike)ClayworksBlocks.CONCRETE.get()))));
        ClayworksRecipeProvider.conditionalRecipe(consumer, RecipeCategory.BUILDING_BLOCKS, (ICondition)CONCRETE_CONFIG, (RecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)concretePowder, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)ClayworksBlocks.CONCRETE_POWDER.get()).m_126127_(Character.valueOf('X'), dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("concrete_powder").m_126132_("has_concrete_powder", (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)((ItemLike)ClayworksBlocks.CONCRETE_POWDER.get()))));
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ICondition condition, RecipeBuilder recipe) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, category, condition, recipe, RecipeBuilder.m_176493_((ItemLike)recipe.m_142372_()));
    }

    public static void conditionalStonecuttingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ICondition condition, ItemLike output, ItemLike input, int count) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, category, condition, (RecipeBuilder)SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)output, (int)count).m_126132_(ClayworksRecipeProvider.m_176602_((ItemLike)input), (CriterionTriggerInstance)ClayworksRecipeProvider.m_125977_((ItemLike)input)), new ResourceLocation("clayworks", ClayworksRecipeProvider.m_176517_((ItemLike)output, (ItemLike)input) + "_stonecutting"));
    }

    public static void conditionalStonecuttingRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ICondition condition, ItemLike output, ItemLike input) {
        ClayworksRecipeProvider.conditionalStonecuttingRecipe(consumer, category, condition, output, input, 1);
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory recipeCategory, ICondition condition, RecipeBuilder recipe, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition(condition).addRecipe(consumer1 -> recipe.m_126140_(consumer1, id)).generateAdvancement(new ResourceLocation(id.m_135827_(), "recipes/" + recipeCategory.m_247710_() + "/" + id.m_135815_())).build(consumer, id);
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, ShapelessRecipeBuilder recipe) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, recipe.f_244182_, condition, (RecipeBuilder)recipe, RecipeBuilder.m_176493_((ItemLike)recipe.m_142372_()));
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, ShapedRecipeBuilder recipe) {
        ClayworksRecipeProvider.conditionalRecipe(consumer, recipe.f_243672_, condition, (RecipeBuilder)recipe, RecipeBuilder.m_176493_((ItemLike)recipe.m_142372_()));
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key, boolean inverted) {
        return new ConfigValueCondition(new ResourceLocation("clayworks", "config"), value, key, (Map)Maps.newHashMap(), inverted);
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key) {
        return ClayworksRecipeProvider.config(value, key, false);
    }

    private static /* synthetic */ String lambda$generateConditionalRecipes$1(ItemLike block) {
        return ClayworksRecipeProvider.m_176602_((ItemLike)block);
    }
}

