/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.util;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosSlotDetector {
    public static boolean doesItemAddSlots(ItemStack stack, Player player, String slotType) {
        if (stack.m_41619_()) {
            return false;
        }
        LazyOptional curiosOpt = CuriosApi.getCurio((ItemStack)stack);
        if (curiosOpt.resolve().isEmpty()) {
            return false;
        }
        ICurio curio = (ICurio)curiosOpt.resolve().get();
        SlotContext slotContext = new SlotContext(slotType, (LivingEntity)player, 0, false, true);
        UUID uuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
        Multimap modifiers = curio.getAttributeModifiers(slotContext, uuid);
        for (Map.Entry entry : modifiers.entries()) {
            Attribute attr = (Attribute)entry.getKey();
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            if (!(attr instanceof SlotAttribute)) continue;
            SlotAttribute slotAttr = (SlotAttribute)attr;
            if (!(modifier.m_22218_() > 0.0) || modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            return true;
        }
        Multimap stackModifiers = CuriosApi.getAttributeModifiers((SlotContext)slotContext, (UUID)uuid, (ItemStack)stack);
        for (Map.Entry entry : stackModifiers.entries()) {
            Attribute attr = (Attribute)entry.getKey();
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            if (!(attr instanceof SlotAttribute) || !(modifier.m_22218_() > 0.0) || modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            return true;
        }
        return false;
    }
}

