/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.tom.storagemod.Content;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.tile.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.RemoteConnections;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class InventoryLinkMenu
extends AbstractContainerMenu
implements IDataReceiver {
    private InventoryCableConnectorBlockEntity te;
    private Inventory pinv;
    private boolean sentList;

    public InventoryLinkMenu(int id, Inventory playerInv) {
        this(id, playerInv, null);
    }

    public InventoryLinkMenu(int id, Inventory playerInv, InventoryCableConnectorBlockEntity tile) {
        super(Content.inventoryLink.get(), id);
        this.te = tile;
        this.pinv = playerInv;
    }

    @Override
    public void receive(CompoundTag tag) {
        if (this.pinv.f_35978_.m_5833_() || this.te == null) {
            return;
        }
        if (tag.m_128441_("remote")) {
            this.te.setRemote(tag.m_128471_("remote"));
            this.sentList = false;
            return;
        }
        UUID id = null;
        if (tag.m_128441_("id")) {
            id = tag.m_128342_("id");
        }
        if (id == null) {
            UUID chn = RemoteConnections.get(this.pinv.f_35978_.m_9236_()).makeChannel(tag, this.pinv.f_35978_.m_20148_());
            this.te.setChannel(chn);
        } else if (tag.m_128471_("select")) {
            this.te.setChannel(id);
        } else if (tag.m_128441_("public")) {
            RemoteConnections.get(this.pinv.f_35978_.m_9236_()).editChannel(id, tag.m_128471_("public"), this.pinv.f_35978_.m_20148_());
        } else {
            RemoteConnections.get(this.pinv.f_35978_.m_9236_()).removeChannel(id, this.pinv.f_35978_.m_20148_());
        }
        this.sentList = false;
    }

    public boolean m_6875_(Player p_38874_) {
        return this.te != null ? this.te.stillValid(p_38874_) : true;
    }

    public void m_38946_() {
        if (this.te == null) {
            return;
        }
        if (!this.sentList) {
            CompoundTag mainTag = new CompoundTag();
            UUID chn = this.te.getChannel();
            if (chn != null) {
                mainTag.m_128362_("selected", chn);
            }
            mainTag.m_128365_("list", (Tag)RemoteConnections.get(this.pinv.f_35978_.m_9236_()).listChannels(this.pinv.f_35978_));
            mainTag.m_128405_("lvl", this.te.getBeaconLevel());
            mainTag.m_128379_("remote", this.te.isRemote());
            NetworkHandler.sendTo((ServerPlayer)this.pinv.f_35978_, mainTag);
            this.sentList = true;
        }
        super.m_38946_();
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }
}

