/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.common.world.StructureSettingsBuilder;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CSStructureModifiers {
    public static final Codec<HolderSet<Structure>> LIST_CODEC = RegistryCodecs.m_206279_((ResourceKey)Registries.f_256944_, (Codec)Structure.f_226553_);
    public static final DeferredRegister<Codec<? extends StructureModifier>> STRUCTURE_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)"celestisynth");
    public static final RegistryObject<Codec<AddSpawnsStructureModifier>> ADD_SPAWNS_STRUCTURE_CODEC = STRUCTURE_MODIFIER_SERIALIZERS.register("add_spawns", () -> RecordCodecBuilder.create(builder -> builder.group((App)LIST_CODEC.fieldOf("structure").forGetter(AddSpawnsStructureModifier::structures), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(AddSpawnsStructureModifier::spawners)).apply((Applicative)builder, AddSpawnsStructureModifier::new)));
    public static final RegistryObject<Codec<AddSpawnsStructureTagModifier>> ADD_SPAWNS_STRUCTURE_TAG_CODEC = STRUCTURE_MODIFIER_SERIALIZERS.register("add_spawns_tag", () -> RecordCodecBuilder.create(builder -> builder.group((App)TagKey.m_203877_((ResourceKey)Registries.f_256944_).fieldOf("structure_tags").forGetter(AddSpawnsStructureTagModifier::structureTag), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(AddSpawnsStructureTagModifier::spawners)).apply((Applicative)builder, AddSpawnsStructureTagModifier::new)));

    public record AddSpawnsStructureTagModifier(TagKey<Structure> structureTag, List<MobSpawnSettings.SpawnerData> spawners) implements StructureModifier
    {
        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.ADD && structure.m_203656_(this.structureTag)) {
                StructureSettingsBuilder structureSettings = builder.getStructureSettings();
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    EntityType type = spawner.f_48404_;
                    structureSettings.getOrAddSpawnOverrides(type.m_20674_()).addSpawn(spawner);
                }
            }
        }

        public Codec<? extends StructureModifier> codec() {
            return (Codec)ADD_SPAWNS_STRUCTURE_TAG_CODEC.get();
        }
    }

    public record AddSpawnsStructureModifier(HolderSet<Structure> structures, List<MobSpawnSettings.SpawnerData> spawners) implements StructureModifier
    {
        public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
            if (phase == StructureModifier.Phase.ADD && this.structures.m_203333_(structure)) {
                StructureSettingsBuilder structureSettings = builder.getStructureSettings();
                for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                    EntityType type = spawner.f_48404_;
                    structureSettings.getOrAddSpawnOverrides(type.m_20674_()).addSpawn(spawner);
                }
            }
        }

        public Codec<? extends StructureModifier> codec() {
            return (Codec)ADD_SPAWNS_STRUCTURE_CODEC.get();
        }
    }
}

