/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.thecelestialworkshop.celestisynth.common.registry.CSRecipeTypes;

public class StarlitFactoryRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final Ingredient baseMaterial;
    protected final Ingredient baseMaterial1;
    protected final Ingredient baseMaterial2;
    protected final Ingredient supportingMaterial;
    protected final Ingredient supportingMaterial1;
    protected final Ingredient supportingMaterial2;
    protected final ItemStack result;
    protected final int forgeTime;

    public StarlitFactoryRecipe(ResourceLocation id, Ingredient baseMaterial, Ingredient baseMaterial1, Ingredient baseMaterial2, Ingredient supportingMaterial, Ingredient supportingMaterial1, Ingredient supportingMaterial2, ItemStack result, int forgeTime) {
        this.id = id;
        this.baseMaterial = baseMaterial;
        this.baseMaterial1 = baseMaterial1;
        this.baseMaterial2 = baseMaterial2;
        this.supportingMaterial = supportingMaterial;
        this.supportingMaterial1 = supportingMaterial1;
        this.supportingMaterial2 = supportingMaterial2;
        this.result = result;
        this.forgeTime = forgeTime;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CSRecipeTypes.STARLIT_FACTORY.get();
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return this.baseMaterial.test(!pInv.m_8020_(0).m_41619_() ? pInv.m_8020_(0) : ItemStack.f_41583_) && this.baseMaterial1.test(!pInv.m_8020_(1).m_41619_() ? pInv.m_8020_(1) : ItemStack.f_41583_) && this.baseMaterial2.test(!pInv.m_8020_(2).m_41619_() ? pInv.m_8020_(2) : ItemStack.f_41583_) && this.supportingMaterial.test(!pInv.m_8020_(3).m_41619_() ? pInv.m_8020_(3) : ItemStack.f_41583_) && this.supportingMaterial1.test(!pInv.m_8020_(4).m_41619_() ? pInv.m_8020_(4) : ItemStack.f_41583_) && this.supportingMaterial2.test(!pInv.m_8020_(5).m_41619_() ? pInv.m_8020_(5) : ItemStack.f_41583_);
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.baseMaterial);
        nonnulllist.add((Object)this.baseMaterial1);
        nonnulllist.add((Object)this.baseMaterial2);
        nonnulllist.add((Object)this.supportingMaterial);
        nonnulllist.add((Object)this.supportingMaterial1);
        nonnulllist.add((Object)this.supportingMaterial2);
        return nonnulllist;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public int getForgeTime() {
        return this.forgeTime;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CSRecipeTypes.STARLIT_FACTORY_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<StarlitFactoryRecipe> {
        private final int defaultForgingTime;

        public Serializer() {
            this.defaultForgingTime = 200;
        }

        public StarlitFactoryRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ItemStack result;
            Ingredient baseMaterial = Ingredient.m_288218_((JsonElement)this.extractJsonElement(pJson, "core_material"), (boolean)true);
            Ingredient baseMaterial1 = Ingredient.m_288218_((JsonElement)this.extractJsonElement(pJson, "supporting_core_material"), (boolean)true);
            Ingredient baseMaterial2 = Ingredient.m_288218_((JsonElement)this.extractJsonElement(pJson, "extra_core_material"), (boolean)true);
            Ingredient supportingMaterial = Ingredient.m_288218_((JsonElement)this.extractJsonElement(pJson, "supporting_material_top"), (boolean)true);
            Ingredient supportingMaterial1 = Ingredient.m_288218_((JsonElement)this.extractJsonElement(pJson, "supporting_material_middle"), (boolean)true);
            Ingredient supportingMaterial2 = Ingredient.m_288218_((JsonElement)this.extractJsonElement(pJson, "supporting_material_bottom"), (boolean)true);
            if (!pJson.has("result")) {
                throw new JsonSyntaxException("mfw you try'na make a recipe without a result item wtf are you trying to cook??");
            }
            if (pJson.get("result").isJsonObject()) {
                result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            } else {
                String resultItemFromJsonBrainrot = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(resultItemFromJsonBrainrot);
                result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException(resultItemFromJsonBrainrot + " does NOT exist, that's not COOL AT ALL!!!")));
            }
            int forgingTime = GsonHelper.m_13824_((JsonObject)pJson, (String)"forging_time", (int)this.defaultForgingTime);
            return new StarlitFactoryRecipe(pRecipeId, baseMaterial, baseMaterial1, baseMaterial2, supportingMaterial, supportingMaterial1, supportingMaterial2, result, forgingTime);
        }

        @Nullable
        public StarlitFactoryRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient baseMaterial = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient baseMaterial1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient baseMaterial2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient supportingMaterial = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient supportingMaterial1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient supportingMaterial2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.m_130267_();
            int forgingTime = pBuffer.m_130242_();
            return new StarlitFactoryRecipe(pRecipeId, baseMaterial, baseMaterial1, baseMaterial2, supportingMaterial, supportingMaterial1, supportingMaterial2, result, forgingTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, StarlitFactoryRecipe pRecipe) {
            pRecipe.baseMaterial.m_43923_(pBuffer);
            pRecipe.baseMaterial1.m_43923_(pBuffer);
            pRecipe.baseMaterial2.m_43923_(pBuffer);
            pRecipe.supportingMaterial.m_43923_(pBuffer);
            pRecipe.supportingMaterial1.m_43923_(pBuffer);
            pRecipe.supportingMaterial2.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130130_(pRecipe.forgeTime);
        }

        public JsonElement extractJsonElement(JsonObject pJson, String memberName) {
            return GsonHelper.m_13885_((JsonObject)pJson, (String)memberName) ? GsonHelper.m_13933_((JsonObject)pJson, (String)memberName) : GsonHelper.m_13930_((JsonObject)pJson, (String)memberName);
        }
    }
}

