/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.item.weapons;

import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.thecelestialworkshop.celestisynth.api.item.CSGeoItem;
import org.thecelestialworkshop.celestisynth.common.attack.aquaflora.AquafloraBlastOffAttack;
import org.thecelestialworkshop.celestisynth.common.attack.aquaflora.AquafloraFlowersAwayAttack;
import org.thecelestialworkshop.celestisynth.common.attack.aquaflora.AquafloraPetalPiercesAttack;
import org.thecelestialworkshop.celestisynth.common.attack.aquaflora.AquafloraSlashFrenzyAttack;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.item.base.SkilledSwordItem;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class AquafloraItem
extends SkilledSwordItem
implements CSGeoItem {
    public AquafloraItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "aquaflora";
    }

    @Override
    public String model(ItemStack stack) {
        if (this.attackController(stack) != null && this.attackController(stack).m_128471_("cs.checkPassiveIfBlooming")) {
            return "aquaflora_blooming";
        }
        return "aquaflora";
    }

    @Override
    public String texture(ItemStack stack) {
        return this.model(stack);
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int useDuration) {
        return ImmutableList.of((Object)new AquafloraPetalPiercesAttack(player, stack, useDuration), (Object)new AquafloraBlastOffAttack(player, stack, useDuration), (Object)new AquafloraSlashFrenzyAttack(player, stack, useDuration), (Object)new AquafloraFlowersAwayAttack(player, stack, useDuration));
    }

    @Override
    public int getPassiveAmount() {
        return 1;
    }

    @Override
    public int getSkillsAmount() {
        return 4;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Player player;
        if (pAttacker instanceof Player && (player = (Player)pAttacker).m_21205_().m_150930_((Item)this) && player.m_21206_().m_150930_((Item)this)) {
            if (player.m_21205_() == pStack) {
                CSEffectEntity.createInstance((LivingEntity)player, null, (CSVisualType)CSVisualTypes.AQUAFLORA_SLICE.get(), 0.0, 1.75, 0.0);
            }
            if (player.m_21206_() == pStack) {
                CSEffectEntity.createInstance((LivingEntity)player, null, (CSVisualType)CSVisualTypes.AQUAFLORA_SLICE_INVERTED.get(), 0.0, 1.75, 0.0);
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    @Override
    public void onPlayerHurt(LivingHurtEvent event, ItemStack stack) {
        if (this.attackController(stack).m_128471_("cs.atkOngoing")) {
            event.setAmount(event.getAmount() * 0.25f);
        }
    }
}

