/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.item.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.thecelestialworkshop.celestisynth.api.item.CSDataPackableStatItem;
import org.thecelestialworkshop.celestisynth.api.item.CSWeapon;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;

public abstract class SkilledAxeItem
extends AxeItem
implements CSWeapon,
CSDataPackableStatItem {
    public static final String ATTACK_INDEX_KEY = "cs.AttackIndex";
    private Lazy<? extends Multimap<Attribute, AttributeModifier>> attributeModMapLazy = Lazy.of(() -> {
        ImmutableMultimap.Builder attrModMapBuilder = ImmutableMultimap.builder();
        attrModMapBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.m_41008_() - 1.0f), AttributeModifier.Operation.ADDITION));
        attrModMapBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.getAttackSpeed().getAsDouble(), AttributeModifier.Operation.ADDITION));
        attrModMapBuilder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(CSDataPackableStatItem.getKBUUIDMod(), "Weapon modifier", this.getAttackKnockback().getAsDouble(), AttributeModifier.Operation.ADDITION));
        if (ForgeMod.BLOCK_REACH.isPresent()) {
            attrModMapBuilder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(CSDataPackableStatItem.getBlockReachUUIDMod(), "Weapon modifier", this.getBlockReach().getAsDouble(), AttributeModifier.Operation.ADDITION));
        }
        if (ForgeMod.ENTITY_REACH.isPresent()) {
            attrModMapBuilder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(CSDataPackableStatItem.getEntityReachUUIDMod(), "Weapon modifier", this.getAttackReach().getAsDouble(), AttributeModifier.Operation.ADDITION));
        }
        return attrModMapBuilder.build();
    });

    public SkilledAxeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, (float)pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @Override
    public abstract ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player var1, ItemStack var2, int var3);

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack heldStack = player.m_21120_(interactionHand);
        CompoundTag data = heldStack.m_41698_("csController");
        if (!player.m_36335_().m_41519_(heldStack.m_41720_()) && !data.m_128471_("cs.hasAnimationBegun")) {
            if (this.m_8105_(heldStack) <= 0) {
                int index = 0;
                for (WeaponAttackInstance attack : this.getPossibleAttacks(player, heldStack, 0)) {
                    if (attack.getCondition()) {
                        data.m_128379_("cs.hasAnimationBegun", true);
                        this.executeAnimation(level, attack.getAnimation(), attack, interactionHand);
                        this.setAttackIndex(heldStack, index);
                        attack.baseStart();
                        player.m_36335_().m_41524_(heldStack.m_41720_(), attack.getCooldown());
                        break;
                    }
                    ++index;
                }
            } else {
                if (player.m_36335_().m_41519_(heldStack.m_41720_()) || data.m_128471_("cs.hasAnimationBegun")) {
                    return InteractionResultHolder.m_19100_((Object)heldStack);
                }
                player.m_6672_(interactionHand);
                return InteractionResultHolder.m_19096_((Object)heldStack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    public void m_5551_(ItemStack itemstack, @NotNull Level level, @NotNull LivingEntity entity, int i) {
        CompoundTag data = itemstack.m_41698_("csController");
        int dur = this.m_8105_(itemstack) - i;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int index = 0;
            for (WeaponAttackInstance attack : this.getPossibleAttacks(player, itemstack, dur)) {
                if (attack.getCondition()) {
                    data.m_128379_("cs.hasAnimationBegun", true);
                    this.executeAnimation(level, attack.getAnimation(), attack, entity.m_21206_() == itemstack ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    this.setAttackIndex(itemstack, index);
                    attack.baseStart();
                    player.m_36335_().m_41524_(itemstack.m_41720_(), attack.getCooldown());
                    break;
                }
                ++index;
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
        CompoundTag data = itemStack.m_41698_("csController");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (data.m_128471_("cs.hasAnimationBegun")) {
                int animationTimer = data.m_128451_("cs.animationTimer");
                data.m_128405_("cs.animationTimer", animationTimer + 1);
                int index = 0;
                for (WeaponAttackInstance attack : this.getPossibleAttacks(player, itemStack, 0)) {
                    if (this.getAttackIndex(itemStack) == index) {
                        attack.baseTickSkill();
                    }
                    ++index;
                }
            }
        }
    }

    public int getAttackIndex(ItemStack stack) {
        return this.attackController(stack).m_128451_(ATTACK_INDEX_KEY);
    }

    public void setAttackIndex(ItemStack stack, int value) {
        this.attackController(stack).m_128405_(ATTACK_INDEX_KEY, value);
    }

    @Override
    public IntSupplier getActualAttackDamage() {
        return null;
    }

    @Override
    public DoubleSupplier getAttackSpeed() {
        return null;
    }

    @Override
    public DoubleSupplier getAttackKnockback() {
        return null;
    }

    @Override
    public DoubleSupplier getAttackReach() {
        return null;
    }

    @Override
    public DoubleSupplier getBlockReach() {
        return null;
    }

    @Override
    public Lazy<? extends Multimap<Attribute, AttributeModifier>> getAttributes() {
        return this.attributeModMapLazy;
    }

    @Override
    public void setAttributes(Lazy<? extends Multimap<Attribute, AttributeModifier>> attributes) {
        this.attributeModMapLazy = attributes;
    }
}

