/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.events;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.thecelestialworkshop.celestisynth.common.entity.mob.misc.RainfallTurret;
import org.thecelestialworkshop.celestisynth.common.entity.mob.misc.StarMonolith;
import org.thecelestialworkshop.celestisynth.common.entity.mob.natural.Traverser;
import org.thecelestialworkshop.celestisynth.common.entity.mob.natural.Veilguard;
import org.thecelestialworkshop.celestisynth.common.entity.tempestboss_scrapped.TempestBoss;
import org.thecelestialworkshop.celestisynth.common.registry.CSAttributes;
import org.thecelestialworkshop.celestisynth.common.registry.CSCapabilities;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSItems;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSAdvancementProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSBlockstateProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSDamageTypeProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSFeatureProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSGlobalLootModifiersProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSItemModelProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSLootTableProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSMobSpawnProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSRecipeProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSStructureProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.CSTagsProvider;
import org.thecelestialworkshop.celestisynth.datagen.providers.compat.CSBetterCombatProvider;

public class CSCommonSetupEvents {

    public static class CSModSetupEvents {
        @SubscribeEvent
        public static void onEntityAttributeModification(EntityAttributeModificationEvent event) {
            CSAttributes.modifyEntityAttributes(event);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onRegistryCreatingEvent(NewRegistryEvent event) {
            event.create(new RegistryBuilder().setName(CSVisualTypes.VISUALS_KEY.m_135782_()).disableSaving());
            event.create(new RegistryBuilder().setName(CSPlayerAnimations.ANIMATIONS_KEY.m_135782_()).disableSaving());
        }

        @SubscribeEvent
        public static void onFMLCommonSetupEvent(FMLCommonSetupEvent event) {
            CSCapabilities.registerCapabilities();
            event.enqueueWork(() -> {
                BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)CSItems.LUNAR_SCRAP.get()}), new ItemStack((ItemLike)CSItems.STARSTRUCK_SCRAP.get())));
                BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42402_}), new ItemStack((ItemLike)CSItems.STARSTRUCK_FEATHER.get())));
            });
        }

        @SubscribeEvent
        public static void onSpawnPlacementRegisterEvent(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)CSEntityTypes.STAR_MONOLITH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, StarMonolith::canSpawn, SpawnPlacementRegisterEvent.Operation.OR);
        }

        @SubscribeEvent
        public static void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
            event.put((EntityType)CSEntityTypes.RAINFALL_TURRET.get(), RainfallTurret.createAttributes().m_22265_());
            event.put((EntityType)CSEntityTypes.STAR_MONOLITH.get(), StarMonolith.createAttributes().m_22265_());
            event.put((EntityType)CSEntityTypes.TRAVERSER.get(), Traverser.createAttributes().m_22265_());
            event.put((EntityType)CSEntityTypes.VEILGUARD.get(), Veilguard.createAttributes().m_22265_());
            event.put((EntityType)CSEntityTypes.TEMPEST.get(), TempestBoss.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void onGatherDataEvent(GatherDataEvent event) {
            DataGenerator dataGenerator = event.getGenerator();
            ExistingFileHelper efh = event.getExistingFileHelper();
            PackOutput output = event.getGenerator().getPackOutput();
            CompletableFuture lookup = event.getLookupProvider();
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSLootTableProvider(output));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSBlockstateProvider(output, efh));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSItemModelProvider(output, efh));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSRecipeProvider(output));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSAdvancementProvider(output, lookup, efh));
            CSTagsProvider.BlockHandler blockTagProvider = new CSTagsProvider.BlockHandler(output, lookup, efh);
            dataGenerator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSTagsProvider.ItemHandler(output, lookup, blockTagProvider.m_274426_(), efh));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSTagsProvider.EntityTypeHandler(output, lookup, efh));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSTagsProvider.BiomeHandler(output, lookup, efh));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSTagsProvider.StructureHandler(output, lookup, efh));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSBetterCombatProvider(output));
            dataGenerator.addProvider(event.includeServer(), (DataProvider)new CSGlobalLootModifiersProvider(output));
            CSModSetupEvents.otherProviders(output, lookup, efh).forEach(provider -> dataGenerator.addProvider(event.includeServer(), provider));
        }

        public static List<DataProvider> otherProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, ExistingFileHelper efh) {
            RegistrySetBuilder builder = new RegistrySetBuilder().m_254916_(Registries.f_268580_, CSDamageTypeProvider::bootstrap).m_254916_(Registries.f_256911_, CSFeatureProvider.ConfiguredFeatures::bootstrap).m_254916_(Registries.f_256988_, CSFeatureProvider.PlacedFeatures::bootstrap).m_254916_(Registries.f_256944_, CSStructureProvider.Structures::bootstrap).m_254916_(Registries.f_256998_, CSStructureProvider.StructureSets::bootstrap).m_254916_(ForgeRegistries.Keys.STRUCTURE_MODIFIERS, CSMobSpawnProvider.StructureModifiers::bootstrap).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ctx -> {
                CSFeatureProvider.BiomeModifiers.bootstrap((BootstapContext<BiomeModifier>)ctx);
                CSMobSpawnProvider.BiomeModifiers.bootstrap((BootstapContext<BiomeModifier>)ctx);
            });
            return List.of(new DatapackBuiltinEntriesProvider(output, lookup, builder, Set.of("celestisynth")), new CSTagsProvider.DamageTypeHandler(output, (CompletableFuture<HolderLookup.Provider>)lookup.thenApply(provider -> CSModSetupEvents.append(provider, builder)), efh));
        }

        private static HolderLookup.Provider append(HolderLookup.Provider provider, RegistrySetBuilder builder) {
            return builder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), provider);
        }
    }

    public static class CSForgeSetupEvents {
    }
}

