/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.entity.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.thecelestialworkshop.celestisynth.api.item.AttackHurtTypes;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.item.weapons.CrescentiaItem;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrescentiaDragon
extends ThrowableProjectile
implements GeoEntity,
CSWeaponUtil {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public LivingEntity chomped;
    public float damage = 2.0f;
    public int lifespan = 100;

    public CrescentiaDragon(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public CrescentiaDragon(EntityType<? extends ThrowableProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public CrescentiaDragon(EntityType<? extends ThrowableProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
        this.f_19811_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 offsetVector = this.m_20184_().m_82541_().m_82490_(6.0);
        for (int i = 0; i < 15; ++i) {
            double xx = this.f_19796_.m_188583_() * (double)0.15f;
            double yy = this.f_19796_.m_188583_() * (double)0.15f;
            double zz = this.f_19796_.m_188583_() * (double)0.15f;
            Vec3 direction = this.m_20182_();
            ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123810_, direction.m_7096_() + offsetVector.m_7096_(), direction.m_7098_() + offsetVector.m_7098_() + 0.5, direction.m_7094_() + offsetVector.m_7094_(), xx, yy, zz);
        }
        List entities = this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(4.0));
        ItemStack fireworkStack = new ItemStack((ItemLike)Items.f_42688_);
        Entity yy = this.m_19749_();
        if (yy instanceof Player) {
            Player playerOwner = (Player)yy;
            List<LivingEntity> entitiesFiltered = entities.stream().filter(ent -> ent instanceof LivingEntity && ent != playerOwner).map(LivingEntity.class::cast).toList();
            if (this.chomped == null && !entitiesFiltered.isEmpty()) {
                this.chomped = entitiesFiltered.get(this.f_19796_.m_188503_(entitiesFiltered.size()));
            }
            for (Entity entityBatch : entities) {
                Projectile projectile;
                LivingEntity target;
                if (entityBatch instanceof LivingEntity && (target = (LivingEntity)entityBatch) != this.m_19749_() && target.m_6084_()) {
                    this.initiateAbilityAttack((LivingEntity)playerOwner, target, this.damage, AttackHurtTypes.RAPID_NO_KB);
                    target.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19597_, 20, 2));
                }
                if (!(entityBatch instanceof Projectile) || (projectile = (Projectile)entityBatch).m_19749_() == this.m_19749_()) continue;
                CrescentiaItem.createCrescentiaFirework(fireworkStack, this.m_9236_(), playerOwner, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), true);
                projectile.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.chomped != null) {
                Vec3 vector = this.m_20182_().m_82520_(0.0, -1.0, 0.0).m_82549_(offsetVector).m_82546_(this.chomped.m_20182_());
                this.chomped.m_20334_(vector.m_7096_(), vector.m_7098_(), vector.m_7094_());
                this.lifespan -= (int)this.chomped.m_21133_(Attributes.f_22278_) * 2;
            }
            if (this.f_19797_ % 5 == 0) {
                if (this.f_19796_.m_188499_()) {
                    CSEffectEntity.createInstance((LivingEntity)playerOwner, (Entity)this, (CSVisualType)CSVisualTypes.CRESCENTIA_STRIKE.get(), 0.0, -1.5, 0.0);
                } else {
                    CSEffectEntity.createInstance((LivingEntity)playerOwner, (Entity)this, (CSVisualType)CSVisualTypes.CRESCENTIA_STRIKE_INVERTED.get(), 0.0, -1.5, 0.0);
                }
            }
            if (this.f_19797_ % 30 == 0) {
                this.m_5496_((SoundEvent)CSSoundEvents.WHIRLWIND.get(), 0.2f, 0.5f + (float)(this.f_19796_.m_188583_() * 0.25));
            }
            CSEffectEntity.createInstance((LivingEntity)playerOwner, (Entity)this, (CSVisualType)CSVisualTypes.SOLARIS_AIR.get());
            if (this.f_19797_ % 10 == 0) {
                float offX = this.f_19796_.m_188501_() * 20.0f - 10.0f;
                float offY = this.f_19796_.m_188501_() * 20.0f - 10.0f;
                float offZ = this.f_19796_.m_188501_() * 20.0f - 10.0f;
                CrescentiaItem.createCrescentiaFirework(fireworkStack, this.m_9236_(), playerOwner, this.m_20185_() + (double)offX, this.m_20186_() + (double)offY, this.m_20189_() + (double)offZ, false);
            }
        }
        if (this.f_19797_ > this.lifespan) {
            this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.MOB);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.MOB);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (pResult.m_82443_() != this.m_19749_()) {
                this.chomped = target;
            }
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6109_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.crescentia_dragon.idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
    }
}

